/**
 * Highcharts JS v11.2.0 (2023-10-30)
 *
 * Vector plot series module
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/vector",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function o(t,e,o,r){t.hasOwnProperty(e)||(t[e]=r.apply(null,o),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}o(e,"Series/Vector/VectorSeriesDefaults.js",[],function(){return{lineWidth:2,marker:void 0,rotationOrigin:"center",states:{hover:{lineWidthPlus:1}},tooltip:{pointFormat:"<b>[{point.x}, {point.y}]</b><br/>Length: <b>{point.length}</b><br/>Direction: <b>{point.direction}\xb0</b><br/>"},vectorLength:20}}),o(e,"Series/Vector/VectorSeries.js",[e["Core/Animation/AnimationUtilities.js"],e["Core/Globals.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"],e["Series/Vector/VectorSeriesDefaults.js"]],function(t,e,o,r,i){var n,s=this&&this.__extends||(n=function(t,e){return(n=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}n(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}),a=t.animObject,p=o.series,c=o.seriesTypes.scatter,h=r.arrayMax,l=r.extend,u=r.merge,d=r.pick,f=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.data=void 0,e.lengthMax=void 0,e.options=void 0,e.points=void 0,e}return s(e,t),e.prototype.animate=function(t){t?this.markerGroup.attr({opacity:.01}):this.markerGroup.animate({opacity:1},a(this.options.animation))},e.prototype.arrow=function(t){var e=t.length/this.lengthMax*this.options.vectorLength/20,o={start:10*e,center:0,end:-10*e}[this.options.rotationOrigin]||0;return[["M",0,7*e+o],["L",-1.5*e,7*e+o],["L",0,10*e+o],["L",1.5*e,7*e+o],["L",0,7*e+o],["L",0,-10*e+o]]},e.prototype.drawPoints=function(){for(var t=this.chart,e=0,o=this.points;e<o.length;e++){var r=o[e],i=r.plotX,n=r.plotY;!1===this.options.clip||t.isInsidePlot(i,n,{inverted:t.inverted})?(r.graphic||(r.graphic=this.chart.renderer.path().add(this.markerGroup).addClass("highcharts-point highcharts-color-"+d(r.colorIndex,r.series.colorIndex))),r.graphic.attr({d:this.arrow(r),translateX:i,translateY:n,rotation:r.direction}),this.chart.styledMode||r.graphic.attr(this.pointAttribs(r))):r.graphic&&(r.graphic=r.graphic.destroy())}},e.prototype.pointAttribs=function(t,e){var o=this.options,r=(null==t?void 0:t.color)||this.color,i=this.options.lineWidth;return e&&(r=o.states[e].color||r,i=(o.states[e].lineWidth||i)+(o.states[e].lineWidthPlus||0)),{stroke:r,"stroke-width":i}},e.prototype.translate=function(){p.prototype.translate.call(this),this.lengthMax=h(this.lengthData)},e.defaultOptions=u(c.defaultOptions,i),e}(c);return l(f.prototype,{drawGraph:e.noop,getSymbol:e.noop,markerAttribs:e.noop,parallelArrays:["x","y","length","direction"],pointArrayMap:["y","length","direction"]}),o.registerSeriesType("vector",f),f}),o(e,"masters/modules/vector.src.js",[],function(){})});//# sourceMappingURL=vector.js.map