/**
 * Highcharts JS v11.2.0 (2023-10-30)
 *
 * (c) 2016-2021 Highsoft AS
 * Authors: Jon Arild Nygard
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/wordcloud",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,o){t.hasOwnProperty(e)||(t[e]=o.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Series/DrawPointUtilities.js",[e["Core/Utilities.js"]],function(t){let{isNumber:e}=t;return{draw:function(t,e){let{animatableAttribs:i,onComplete:o,css:n,renderer:r}=e,a=t.series&&t.series.chart.hasRendered?void 0:t.series&&t.series.options.animation,s=t.graphic;if(e.attribs={...e.attribs,class:t.getClassName()},t.shouldDraw())s||(s="text"===e.shapeType?r.text():"image"===e.shapeType?r.image(e.imageUrl||"").attr(e.shapeArgs||{}):r[e.shapeType](e.shapeArgs||{}),t.graphic=s,s.add(e.group)),n&&s.css(n),s.attr(e.attribs).animate(i,!e.isNew&&a,o);else if(s){let e=()=>{t.graphic=s=s&&s.destroy(),"function"==typeof o&&o()};Object.keys(i).length?s.animate(i,void 0,()=>e()):e()}}}}),i(e,"Series/Wordcloud/WordcloudPoint.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){let{column:{prototype:{pointClass:i}}}=t.seriesTypes,{extend:o}=e;class n extends i{constructor(){super(...arguments),this.dimensions=void 0,this.options=void 0,this.polygon=void 0,this.rect=void 0,this.series=void 0}isValid(){return!0}}return o(n.prototype,{weight:1}),n}),i(e,"Series/Wordcloud/WordcloudSeriesDefaults.js",[],function(){return{allowExtendPlayingField:!0,animation:{duration:500},borderWidth:0,clip:!1,colorByPoint:!0,cropThreshold:1/0,minFontSize:1,maxFontSize:25,placementStrategy:"center",rotation:{from:0,orientations:2,to:90},showInLegend:!1,spiral:"rectangular",style:{fontFamily:"sans-serif",fontWeight:"900",whiteSpace:"nowrap"},tooltip:{followPointer:!0,pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.weight}</b><br/>'}}}),i(e,"Series/Wordcloud/WordcloudUtils.js",[e["Core/Globals.js"],e["Core/Utilities.js"]],function(t,e){let{deg2rad:i}=t,{extend:o,find:n,isNumber:r,isObject:a,merge:s}=e;function l(t,e){return!(e.left>t.right||e.right<t.left||e.top>t.bottom||e.bottom<t.top)}function h(t){let e,i=t.axes||[];return i.length||(i=[],t.concat([t[0]]).reduce((t,e)=>{let o=function(t,e){let i=e[0]-t[0],o=e[1]-t[1];return[[-o,i],[o,-i]]}(t,e),r=o[0];return n(i,t=>t[0]===r[0]&&t[1]===r[1])||i.push(r),e}),t.axes=i),i}function d(t,e){let i=t.map(t=>{let i=t[0],o=t[1],n=e[0],r=e[1];return i*n+o*r});return{min:Math.min.apply(this,i),max:Math.max.apply(this,i)}}function u(t,e){let i=h(t),o=h(e),r=i.concat(o),a=!n(r,i=>(function(t,e,i){let o=d(e,t),n=d(i,t),r=!(n.min>o.max||n.max<o.min);return!r})(i,t,e));return a}function c(t,e){let i=4*t,o=Math.ceil((Math.sqrt(i)-1)/2),n=2*o+1,r=Math.pow(n,2),a=!1;return n-=1,t<=1e4&&("boolean"==typeof a&&i>=r-n&&(a={x:o-(r-i),y:-o}),r-=n,"boolean"==typeof a&&i>=r-n&&(a={x:-o,y:-o+(r-i)}),r-=n,"boolean"==typeof a&&(a=i>=r-n?{x:-o+(r-i),y:o}:{x:o,y:o-(r-i-n)}),a.x*=5,a.y*=5),a}function p(t,e){let i=r(e)?e:14,o=Math.pow(10,i);return Math.round(t*o)/o}function m(t,e){let o=t[0],n=t[1],r=-(i*e),a=Math.cos(r),s=Math.sin(r);return[p(o*a-n*s),p(o*s+n*a)]}function g(t,e,i){let o=t[0]-e[0],n=t[1]-e[1],r=m([o,n],i);return[r[0]+e[0],r[1]+e[1]]}return{archimedeanSpiral:function(t,e){let i=e.field,o=i.width*i.width+i.height*i.height,n=.8*t,r=!1;return t<=1e4&&!(Math.min(Math.abs((r={x:n*Math.cos(n),y:n*Math.sin(n)}).x),Math.abs(r.y))<o)&&(r=!1),r},extendPlayingField:function(t,e){let i,o,n,r,l,h;return a(t)&&a(e)?(i=e.bottom-e.top,l=(o=e.right-e.left)*(n=t.ratioX)>i*(r=t.ratioY)?o:i,h=s(t,{width:t.width+2*(l*n),height:t.height+2*(l*r)})):h=t,h},getBoundingBoxFromPolygon:function(t){return t.reduce(function(t,e){let i=e[0],o=e[1];return t.left=Math.min(i,t.left),t.right=Math.max(i,t.right),t.bottom=Math.max(o,t.bottom),t.top=Math.min(o,t.top),t},{left:Number.MAX_VALUE,right:-Number.MAX_VALUE,bottom:-Number.MAX_VALUE,top:Number.MAX_VALUE})},getPlayingField:function(t,e,i){let o=i.reduce(function(t,e){let i=e.dimensions,o=Math.max(i.width,i.height);return t.maxHeight=Math.max(t.maxHeight,i.height),t.maxWidth=Math.max(t.maxWidth,i.width),t.area+=o*o,t},{maxHeight:0,maxWidth:0,area:0}),n=Math.max(o.maxHeight,o.maxWidth,.85*Math.sqrt(o.area)),r=t>e?t/e:1,a=e>t?e/t:1;return{width:n*r,height:n*a,ratioX:r,ratioY:a}},getPolygon:function(t,e,i,o,n){let r=[t,e],a=t-i/2,s=t+i/2,l=e-o/2,h=e+o/2;return[[a,l],[s,l],[s,h],[a,h]].map(function(t){return g(t,r,-n)})},getRandomPosition:function(t){return Math.round(t*(Math.random()+.5)/2)},getRotation:function(t,e,i,o){let n=!1,a;return r(t)&&r(e)&&r(i)&&r(o)&&t>0&&e>-1&&o>i&&(a=(o-i)/(t-1||1),n=i+e%t*a),n},getScale:function(t,e,i){let o=2*Math.max(Math.abs(i.top),Math.abs(i.bottom)),n=2*Math.max(Math.abs(i.left),Math.abs(i.right));return Math.min(n>0?1/n*t:1,o>0?1/o*e:1)},getSpiral:function(t,e){let i=[];for(let o=1;o<1e4;o++)i.push(t(o,e));return t=>t<=1e4&&i[t-1]},intersectionTesting:function(t,e){let i=e.placed,r=e.field,s=e.rectangle,h=e.polygon,d=e.spiral,c=t.rect=o({},s),p=1,m={x:0,y:0};for(t.polygon=h,t.rotation=e.rotation;!1!==m&&(function(t,e){let i=t.rect,o=t.polygon,r=t.lastCollidedWith,a=function(e){let n=l(i,e.rect);return n&&(t.rotation%90||e.rotation%90)&&(n=u(o,e.polygon)),n},s=!1;return!r||(s=a(r))||delete t.lastCollidedWith,s||(s=!!n(e,function(e){let i=a(e);return i&&(t.lastCollidedWith=e),i})),s}(t,i)||function(t,e){let i={left:-(e.width/2),right:e.width/2,top:-(e.height/2),bottom:e.height/2};return!(i.left<t.left&&i.right>t.right&&i.top<t.top&&i.bottom>t.bottom)}(c,r));)a(m=d(p))&&(c.left=s.left+m.x,c.right=s.right+m.x,c.top=s.top+m.y,c.bottom=s.bottom+m.y,t.polygon=function(t,e,i){return i.map(function(i){return[i[0]+t,i[1]+e]})}(m.x,m.y,h)),p++;return m},isPolygonsColliding:u,isRectanglesIntersecting:l,rectangularSpiral:function(t,e){let i=c(t,e),o=e.field;return i&&(i.x*=o.ratioX,i.y*=o.ratioY),i},rotate2DToOrigin:m,rotate2DToPoint:g,squareSpiral:c,updateFieldBoundaries:function(t,e){return(!r(t.left)||t.left>e.left)&&(t.left=e.left),(!r(t.right)||t.right<e.right)&&(t.right=e.right),(!r(t.top)||t.top>e.top)&&(t.top=e.top),(!r(t.bottom)||t.bottom<e.bottom)&&(t.bottom=e.bottom),t}}}),i(e,"Series/Wordcloud/WordcloudSeries.js",[e["Series/DrawPointUtilities.js"],e["Core/Globals.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"],e["Series/Wordcloud/WordcloudPoint.js"],e["Series/Wordcloud/WordcloudSeriesDefaults.js"],e["Series/Wordcloud/WordcloudUtils.js"]],function(t,e,i,o,n,r,a){let{noop:s}=e,{column:l}=i.seriesTypes,{extend:h,isArray:d,isNumber:u,isObject:c,merge:p}=o,{archimedeanSpiral:m,extendPlayingField:g,getBoundingBoxFromPolygon:f,getPlayingField:y,getPolygon:x,getRandomPosition:b,getRotation:w,getScale:M,getSpiral:S,intersectionTesting:W,isPolygonsColliding:v,rectangularSpiral:A,rotate2DToOrigin:j,rotate2DToPoint:C,squareSpiral:F,updateFieldBoundaries:P}=a;class T extends l{constructor(){super(...arguments),this.data=void 0,this.options=void 0,this.points=void 0}pointAttribs(t,i){let o=e.seriesTypes.column.prototype.pointAttribs.call(this,t,i);return delete o.stroke,delete o["stroke-width"],o}deriveFontSize(t,e,i){let o=u(t)?t:0,n=u(e)?e:1,r=u(i)?i:1;return Math.floor(Math.max(r,o*n))}drawPoints(){let e=this.hasRendered,i=this.xAxis,o=this.yAxis,n=this.chart,r=this.group,a=this.options,s=a.animation,l=a.allowExtendPlayingField,d=n.renderer,p=[],m=this.placementStrategy[a.placementStrategy],b=a.rotation,w=this.points.map(function(t){return t.weight}),v=Math.max.apply(null,w),A=this.points.concat().sort((t,e)=>e.weight-t.weight),j=d.text().add(r),C;for(let t of(this.group.attr({scaleX:1,scaleY:1}),A)){let e=1/v*t.weight,i=this.deriveFontSize(e,a.maxFontSize,a.minFontSize),o=h({fontSize:i+"px"},a.style);j.css(o).attr({x:0,y:0,text:t.name});let n=j.getBBox(!0);t.dimensions={height:n.height,width:n.width}}C=y(i.len,o.len,A);let F=S(this.spirals[a.spiral],{field:C});for(let i of A){let o=1/v*i.weight,n=this.deriveFontSize(o,a.maxFontSize,a.minFontSize),y=h({fontSize:n+"px"},a.style),w=m(i,{data:A,field:C,placed:p,rotation:b}),M=h(this.pointAttribs(i,i.selected&&"select"),{align:"center","alignment-baseline":"middle","dominant-baseline":"middle",x:w.x,y:w.y,text:i.name,rotation:u(w.rotation)?w.rotation:void 0}),S=x(w.x,w.y,i.dimensions.width,i.dimensions.height,w.rotation),j=f(S),T=W(i,{rectangle:j,polygon:S,field:C,placed:p,spiral:F,rotation:w.rotation}),U;!T&&l&&(C=g(C,j),T=W(i,{rectangle:j,polygon:S,field:C,placed:p,spiral:F,rotation:w.rotation})),c(T)?(M.x=(M.x||0)+T.x,M.y=(M.y||0)+T.y,j.left+=T.x,j.right+=T.x,j.top+=T.y,j.bottom+=T.y,C=P(C,j),p.push(i),i.isNull=!1,i.isInside=!0):i.isNull=!0,s&&(U={x:M.x,y:M.y},e?(delete M.x,delete M.y):(M.x=0,M.y=0)),t.draw(i,{animatableAttribs:U,attribs:M,css:y,group:r,renderer:d,shapeArgs:void 0,shapeType:"text"})}j=j.destroy();let T=M(i.len,o.len,C);this.group.attr({scaleX:T,scaleY:T})}hasData(){return c(this)&&!0===this.visible&&d(this.points)&&this.points.length>0}getPlotBox(){let t=this.chart,e=t.inverted,i=this[e?"yAxis":"xAxis"],o=this[e?"xAxis":"yAxis"],n=i?i.len:t.plotWidth,r=o?o.len:t.plotHeight,a=i?i.left:t.plotLeft,s=o?o.top:t.plotTop;return{translateX:a+n/2,translateY:s+r/2,scaleX:1,scaleY:1}}}return T.defaultOptions=p(l.defaultOptions,r),h(T.prototype,{animate:s,animateDrilldown:s,animateDrillupFrom:s,isCartesian:!1,pointClass:n,setClip:s,placementStrategy:{random:function(t,e){let i=e.field,o=e.rotation;return{x:b(i.width)-i.width/2,y:b(i.height)-i.height/2,rotation:w(o.orientations,t.index,o.from,o.to)}},center:function(t,e){let i=e.rotation;return{x:0,y:0,rotation:w(i.orientations,t.index,i.from,i.to)}}},pointArrayMap:["weight"],spirals:{archimedean:m,rectangular:A,square:F},utils:{extendPlayingField:g,getRotation:w,isPolygonsColliding:v,rotate2DToOrigin:j,rotate2DToPoint:C}}),i.registerSeriesType("wordcloud",T),T}),i(e,"masters/modules/wordcloud.src.js",[],function(){})});//# sourceMappingURL=wordcloud.js.map