$(document).ready(function() {

	$('input[name=api-id],input[name=api-token]').change(function() {
		var curval = $(this).val();
		var name = $(this).prop('name');
		//console.log(curval + ' / ' + name);
		$('body a').each(function() {
			var href = $( this ).prop('href');
			var value = replace_URL_parameters(href, name.replace('api-', ''), curval);
			$(this).prop('href', value).text(value).hide().fadeIn();
		});
	});

	$('a.api-get').click(function() {

		$.get( $(this).prop('href'), function(data) {
				$('#api-result pre').html(syntaxHighlight(JSON.stringify(data, null, 2))).hide().fadeIn();
			})
			.fail(function() {
				$('#api-result pre').html( "something went wrong !" ).hide().fadeIn();
			});
		return false;
		});

	
	$("a.out").attr("target", "_blank");
	
	$('#printer a').click(function(e){
	     window.print();
	     e.preventDefault();
	});
	
	$("a[href^='#footnote']").each(function(){
	  var hrefval = window.location.href + $(this).attr('href');
	  $(this).attr('href', hrefval);
	});
	
	$("a.login-link").click(function(){
		$("html, body").animate({ scrollTop: '0'}, 500);
			return false;
	});
	

//	$("#content img").each(
//			function(i) {
//				
//				// we get required data
//				var captiontext = $(this).attr('alt');
//				var outerwidth = $(this).outerWidth();
//				var width = $(this).css('width');
//				var border = $(this).css('border');
//				var marginleft = $(this).css('margin-left');
//				var marginright = $(this).css('margin-right');
//				var margintop = $(this).css('margin-top');
//				var marginbottom = $(this).css('margin-bottom');
//				var float = $(this).css('float');
//
//				// we create a wrapper and style it
//				$(this).wrap('<div class="imgwrapper"></div>');
//				$(this).parent().append('<div class="caption">' + captiontext + '</div>');
//				
//				// we calculate dynamically the width of the caption
//				var pleft = $('.caption').css('padding-left').replace('px', '');
//				var pright = $('.caption').css('padding-right').replace('px', '');
//
//				var caption_style = 'width:' + (outerwidth - pleft -pright) +'px';
//				var wrapper_style = 'float:' + float + ';margin-left:' + marginleft + ';margin-right:' + marginright + ';margin-top:' + margintop + ';margin-bottom:' + marginbottom + ';width:' + outerwidth + 'px;';
//				
//				// finally we apply styles
//				$(this).parent().attr('style', wrapper_style);
//				$(this).next().attr('style', caption_style);
//				
//				// we remove margin on image
//				$(this).css('margin', '0');
//
//				// we bind behavior
//				$(this).parent().bind({
//					mouseenter : function(e) {
//						$(this).find("div.caption").show();
//					},
//					mouseleave : function(e) {
//						$(this).find("div.caption").hide();
//					}
//				});
//
//			});
});

function getRandomInt(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

function number_f(nb) {
	nb = nb.toString().replace('.', ',');
	nb = nb.replace(/\B(?=(\d{3})+(?!\d))/g, " ");
	return nb;
}

function cookieAlert(container, msg) {
	$(document).ready(function() {
		if (!navigator.cookieEnabled) {
			$(container).empty();
			$(container).append('<p class="error">' + msg + '</p>');
		}
		return true;
	});
}

function syntaxHighlight(json) {
	if (typeof json != 'string') {
		json = JSON.stringify(json, undefined, 2);
	}
	json = json.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
	return json.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g, function (match) {
		var cls = 'number';
		if (/^"/.test(match)) {
			if (/:$/.test(match)) {
				cls = 'key';
			} else {
				cls = 'string';
			}
		} else if (/true|false/.test(match)) {
			cls = 'boolean';
		} else if (/null/.test(match)) {
			cls = 'null';
		}
		return '<span class="' + cls + '">' + match + '</span>';
	});
}

function replace_URL_parameters(url, param, value) {

	var newhref = url.split("&");
	for (var i = 0; i < newhref.length; i++) {
		//console.log(newhref[i]);
		if(newhref[i].startsWith(param +"=")) newhref[i] =  param + '=' + value.toString();
	}
	return newhref.join('&');
}