<?php
/**
 * News module
 * 
 * Set-up module related menu in back-office
 * 
 * @package linea21\modules\news
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('news')) ReloadIndex('admin');
////////////

$rub_link_add=$rub_link."&amp;todo=add";
$rub_link_list=$rub_link."&amp;todo=list";
$rub_link_mod=$rub_link."&amp;todo=mod";
$rub_link_det=$rub_link."&amp;todo=det";

$search="search.php?rub=".$rub;
if($todo=='add') $title=_t('news','add');
if($todo=='list') $title=_t('news','list');
if($todo=='mod') $title=_t('news','mod');
if($todo=='sup') $title=_t('news','sup');
if($todo=='det') $title=_t('news','det');
?>
<div id="itemenu">
	<h1><?php echo $title; ?></h1>
	<div class="contentlink">
		<?php $dispatcher->notify(new sfEvent('secondary_menu', 'admin_news.menu_start'));?>
		<a href="<?php echo $rub_link_add; ?>" title="<?php echo _t('news','add');?>" class="add-link"><?php echo _t('news','add');?></a>
		<a href="<?php echo $rub_link_list; ?>" title="<?php echo _t('news','list');?>" class="list-link"><?php echo _t('news','list');?></a>
		<a href="<?php echo $search; ?>" title="<?php echo _t('menu','search');?>" class="search-link"><?php echo _t('menu','search');?></a>
		<?php $dispatcher->notify(new sfEvent('secondary_menu', 'admin_news.menu_end'));?>
	</div>
</div>