<?php
/**
 * Default accessibility english file
 * 
 * This file can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\core\public
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>


<?php
// set HTML Title
SetHTMLTitle('Linea21 web accessibility charter');
setBreadcrumb(array('Linea21 web accessibility charter' => false));
?>

<div id="accessibilite">
<h1>Linea21 web accessibility charter</h1>
<div class="sub-title">This website is designed
to be read by all users, independently of their handicaps, and hardware
devices.</div>


<h2>Access key</h2>
<p>Most of web-browsers allows user to open links by keys combination.<br />
Each page has its own <span xml:lang="en">accesskey</span> :</p>
<dl>
	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['accessibility']['accesskey'] ?></kbd>
	:</dt>
	<dd>accessibility charter</dd>
	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['home']['accesskey'] ?></kbd>
	:</dt>
	<dd>Home</dd>
	<dt xml:lang="en">Access key <kbd>2</kbd> :</dt>
	<dd>Content</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['search']['accesskey'] ?></kbd>
	:</dt>
	<dd>Search</dd>

</dl>
<br style="clear: both;" />
<h2 style="margin-top: 1em">Web standards respectful</h2>
<ul>
	<li>Each page was validated on <abbr title="HyperText Markup Language">HTML</abbr>5</li>
	<li>Each page respects a semantic structure. H1 tags are used for main titles, H2 tags are used for sub-titles.</li>
</ul>


<h2>Navigation helpers</h2>
<ul>
	<li>Each page has navigation items and are related to others. <br />
	<pre>
			<code>
&lt;link rel="home" title="home" href="home" /&gt;
&lt;link rel="search" title="search" href="search" /&gt;
&lt;link rel="help" title="Linea21 accessibility charter" href="accessibility" /&gt;
			</code>
		</pre></li>
	<li>All pages include a search field (access key <kbd>4</kbd>).</li>
</ul>

<h2>Links</h2>
<ul>
	<li>Most of the links have a "title" attribute given a description of the current link</li>
	<li>Links are written to keep a semantic value even beyond the context.</li>
	<li>Scripts langages are used to enhance navigation confort, but they can be disabled without reducing accessibility of the content.</li>
</ul>

<h2>Images</h2>
<ul>
	<li>All ornamental images are <abbr title="Cascading Style Sheet">CSS</abbr> included.</li>
	<li>Images as content have descriptive tag <acronym title="Alternative">Alt</acronym>.</li>
</ul>

<h2>Forms</h2>
<ul>
	<li>An effort was done to make forms accessible : the 'LABEL' tag gives sense to associated fields.</li>
</ul>

<h2>Graphic design</h2>
<ul>
	<li>This website uses (<abbr title="Cascading Style Sheet">CSS</abbr>) style sheets for layout. Even if your browser does not support <abbr
		title="Cascading Style Sheet">CSS</abbr>, the content is still readable.</li>
	<li>This website only uses relative font sizes, compatible with the "text size" option of your web-browser. Use the shortcut <kbd>ctrl + wheel mouse</kbd> to change the font size.</li>
</ul>

<h2>Warning - responsability</h2>
<ul>
	<li>The content published on this site is not the property of <a href="<?php echo SITE_LINEA_URL; ?>">Linea21</a>, we can't assure the warranty of a perfect data accessibility on this website.</li>
	<li>Do not hesitate to send us your critics or remarks regarding the website accessibility: <a href="mailto:<?php echo MAIL_LINEA; ?>"><?php echo MAIL_LINEA; ?></a></li>
</ul>

<h2>References</h2>
<ul>
	<li><a href="http://www.w3.org/TR/WCAG21/" title="Web Content Accessibility Guidelines (WCAG) 2.1" hreflang="en">Web Content Accessibility Guidelines (WCAG) 2.1 (<abbr title="World Wide Web Consortium">W3C</abbr>)
	home page</a>.</li>
</ul>

<h2>Free tools</h2>
<ul>
	<li><a href="http://validator.w3.org/" hreflang="en">W3C MarkUp Validation Service</a> : Page syntax check <abbr title="HyperText Markup Language ">HTML</abbr> and <abbr title="eXtensible HyperText Markup Language">XHTML</abbr>.</li>
	<li><a href="http://jigsaw.w3.org/css-validator/" hreflang="en">W3C CSS Validation service</a> : Cascading stylesheet conformity check.</li>
	<li><a href="https://wave.webaim.org/" title="Access to WAVE Web Accessibility Evaluation Tools" hreflang="en">WAVE tool</a></li>
	<li><a href="http://www.delorie.com/web/wpbcv.html" hreflang="en">Web Page Backward Compatibility Viewer</a> : to ensure the compatibility of
	your website with old browsers.</li>
</ul>
</div>