<?php
/**
 * Default contribute template
 * 
 * This file can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\core\public
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>

<?php

if(defined('MOD_COMMENT') && MOD_COMMENT == 1 && commentEnabled('contribute')) {

  $id = 1;

  SetHTMLTitle(_t('comment','contribute_title'));
  setBreadcrumb(array(_t('comment','contribute_title') => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['contribute']['linkvalue']))));

  postCommentAction(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $id));

  $nbComments = getNbComments(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $id));
  
  $slot = get_page_slot('contribute'); // default slot
  
  echo '<h1>'._t('comment','contribute_title').'</h1>'.PHP_EOL;
  echo '<div class="sub-title">'.PHP_EOL;
  if($slot) echo $slot;
  else echo _t('comment','contribute_chapo'). ' ';
  if($nbComments == 0) echo '<span class="contrib-counter-p">'._t('comment','contrib_none').'</span>';
  elseif($nbComments == 1) echo '<span class="contrib-counter-p">'._t('comment','contrib_singular').'</span>';
  else printf('<span class="contrib-counter-p">'._t('comment','contrib_plural').'</span>', '<span class="contrib-counter">' . $nbComments . '</span>');
  echo '</div>'.PHP_EOL;

  displayCommentForm(array('module'=> ActiveItemKey($GLOBALS['activeitem']), 'module_id'=> $id));

  if(commentEnabled('contribute')) {
      echo '<hr />';
      echo '<h3>'._t('comment', 'contribute_item').'</h3>'.PHP_EOL;
      echo '<div id="contribution">'.PHP_EOL;
      displayComments(array('module'=> 'contribute', 'module_id'=> '1', 'order_by' => 'ASC'), false, true);
      echo '</div>'.PHP_EOL;
  }

} else {
  ReloadIndex(CURRENT_APP);
}

?>