<?php
/**
 * Default message template
 * 
 * This file can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\core\public
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>

<?php
if( ActiveItemKey($GLOBALS['activeitem']) =='comment-unsubscribe') {
  // set HTML Title
  SetHTMLTitle(_t('comment','unsubscribe_title'));
  setBreadcrumb(array(_t('comment','unsubscribe_title') => false));
  $a['module']= $_GET['name'];
  $a['module_id']= $_GET['id'];
  $a['email']= $_GET['email'];
  include_once('../class/class.comment.php');
  $comm = new comment;
  $r = $comm->unsubscribe($a, $GLOBALS['sql_object']);

  $item = $comm->getCommentItem($a, $GLOBALS['sql_object']);
  $itemM = itemMapping($a['module']);

  $full_item = $item[0]['item_title'] .' ('.$itemM['name'].')';

  echo '<h1>'._t('comment','unsubscribe_title').'</h1>'.PHP_EOL;
  if($r === true) {
    echo '<div class="confirmed">'.PHP_EOL;
    echo $full_item . ' : ' ._t('comment','unsubscribe_successful').PHP_EOL;
    echo '</div>'.PHP_EOL;
  }

}


if( ActiveItemKey($GLOBALS['activeitem']) =='subscribe-newsletter') {
  // set HTML Title
  SetHTMLTitle(_t('newsletter','subscribe_title'));
  setBreadcrumb(array(_t('newsletter','subscribe_title') => false));
  include_once('../newsletter/subscribe.php');
  echo '<h1>'._t('newsletter','subscribe_title').'</h1>'.PHP_EOL;
  echo '<div class="sub-title">'.PHP_EOL;
  echo _t('divers','newsletter_public_comment').PHP_EOL;
  echo '</div>'.PHP_EOL;
  if(isset($msg)) {
    echo '<div class="'.$msg['code'].'">'.PHP_EOL;
    echo $msg['string'].PHP_EOL;
    echo '</div>'.PHP_EOL;
  }

}

if( ActiveItemKey($GLOBALS['activeitem']) =='contact') {
  // set HTML Title
  SetHTMLTitle(_t('contact','contact_us'));
  setBreadcrumb(array(_t('contact','contact_us') => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['contact']['linkvalue']))));

  $name='';
  $email='';
  $subject='';
  $body='';
  
  if(isset($_GET['s'])) $subject = htmlentities(urldecode($_GET['s']), ENT_QUOTES, 'utf-8');
  

  if(isset($_POST['name'])) {
    $passed = true;
    $name=$_POST['name'];
    $email=$_POST['email'];
    $subject=$_POST['subject'];
    $body=$_POST['body'];

    if(strlen($body)< 8) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'body'));
      $class='error';
      $passed = false;
    }
    if(strlen($subject)< 3) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'subject'));
      $class='error';
      $passed = false;
    }
    if(!validEmail($email)) {
      $msg=sprintf(_t('contact','email_error'), $email);
      $class='error';
      $passed = false;
    }
    if(strlen($email)< 3) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'email'));
      $class='error';
      $passed = false;
    }
    if(strlen($name)< 3) {
      $msg=sprintf(_t('contact','str_error'), _t('contact', 'name'));
      $class='error';
      $passed = false;
    }
    
    // prevent spam only if enabled
    if(defined('CONTACT_ANTISPAM') && CONTACT_ANTISPAM ==1) {
        if($_SESSION['securityaction']!=md5($_POST['securitycode'])) {
            $msg=_t('security','message');
            $class='error';
            $passed = false;
        }
    }
    
    if($passed == true) {
      $class = 'info';
      $msg = _t('contact', 'message_sent');
      include_once(override('../mail/send.php'));
      $emailContainer['recipient'] = SITE_MAIL;
      $emailContainer['from_name'] = $name;
      $emailContainer['from'] = $email;
      $emailContainer['reply_to'] = array( $email => $name);
      $emailContainer['subject'] = formatText($subject, '2HTML') . ' - '. SITE_NAME;
      $emailContainer['html_body'] = formatText($body, '2HTML')."<br /><br />\n\n(".$name . ' - '. $email . ")<br /><br />\n\n----------------<br />\n".CURRENT_APP_URL;
      $emailContainer['txt_body'] = strip_tags($emailContainer['html_body']);
      
      $cip = i2c_realip();
      
      $obanIP = new banIP();
   
      if($obanIP->isBannedIP($cip)) {
          logfile ( LOG_MAILER, array ('[BANNED IP DETECTED]', sprintf('Email from %s is rejected', $cip), $cip, $emailContainer ['subject'], $emailContainer['recipient']));
      } else {
          
          // we add ability to ban IP in footer
          $emailContainer['txt_body'] = strip_tags($emailContainer['html_body']). "\n". sprintf(_t('mail','ban_ip'), $cip) . ' : ' . SITE_ROOT_URL.'admin/index.php?rub=system&todo=ban-ip-add&id='.$cip;
          $emailContainer['html_body'] = $emailContainer['html_body']. '<p><a href="'.SITE_ROOT_URL.'admin/index.php?rub=system&todo=ban-ip-add&id='.$cip.'">' . sprintf(_t('mail','ban_ip'), $cip) . '</a></p>';
          
          $r = send_email($emailContainer);
          
          if(isset($_POST['receive_copy'])) {
              
          	$emailContainer['recipient'] = $email;
          	$emailContainer['subject'] = $emailContainer['subject']. ' ('._t('contact','copy') .')';
          	$emailContainer['html_body'] = '<p><strong>'. _t('contact','copy'). ' : </strong></p> ' . formatText($body, '2HTML')."<br /><br />\n\n(".$name . ' - '. $email . ")<br /><br />\n\n----------------<br />\n".CURRENT_APP_URL;
          	$emailContainer['txt_body'] = ''. _t('contact','copy'). ' :\n' .strip_tags($emailContainer['html_body']);;
          	
          	$r = send_email($emailContainer);
          }
      }
    }
  }

  echo '<h1>'._t('contact','contact_us').'</h1>'.PHP_EOL;
  
  $slot = get_page_slot('contact'); // default slot
  if($slot) echo '<div class="sub-title">'.$slot.'</div>'.PHP_EOL;
  
  if(isset($passed)) echo '<div class="'.$class.'">'.$msg.'</div>'.PHP_EOL;

  if(!isset($passed) || $passed == false) {
  	
  	$output  = '<form id="contactform" action="index.php" method="post">';
  	$output .= '<label class="labelised" for="name">'.mb_ucfirst(_t('contact', 'name')).' : </label>';
  	$output .= '<input name="name" id="name" class="shorttextfield" title="title" size="30" maxlength="100" type="text" required>';
  	$output .= '<br class="mtl" />';
  	$output .= '<label class="labelised" for="email">' . mb_ucfirst(_t('contact', 'email')). ' : </label>';
  	$output .= '<input name="email" id="email" class="shorttextfield" title="title" size="30" maxlength="150" type="email" required>';
  	$output .= '<br class="mtl" />';
  	$output .= '<label class="labelised" for="subject">'. mb_ucfirst(_t('contact', 'subject')). ' : </label>';
  	$output .= '<input name="subject" id="subject" class="shorttextfield" title="title" size="30" maxlength="150" type="text" value="'.$subject.'" required>';
  	$output .= '<br class="mtl" />';
  	$output .= '<label class="labelised" for="body">' . mb_ucfirst(_t('contact', 'body')) .' : </label>';
  	$output .= '<textarea name="body" id="body" cols="60" rows="10" required></textarea>';
  	if(defined('CONTACT_ANTISPAM') && CONTACT_ANTISPAM ==1) {
  	    $output.='<p class="antispam">'.PHP_EOL;
  	    $output.='<span class="labelmargin labelised">&nbsp;</span>';
  	    $output.='<img src="../lib/securitycode.php" alt="' .mb_ucfirst( _t('security','info2')) .'" id="securityimg" /><span class="labelised antispam-notice">'.  mb_ucfirst(_t('security','info2')).'</span>';
  	    $output.='</p>'.PHP_EOL;
  	    $output.='<p><label for="securitycode" class="labelised">' . mb_ucfirst(_t('antispam','info')) . ' * : </label>';
  	    $output.='<input type="text" class="textfield" id="securitycode" maxlength="5" name="securitycode" /></p> ';
  	}
  	$output .= '<div class="label-leftmargin mtm">';
  	$output .= '<input name="receive_copy" id="receive_copy" value="1" checked type="checkbox" class="switch">';
  	$output .= '<label class="labelised autowidth" for="receive_copy">' . _t('contact', 'receive_copy') .'</label>';
  	$output .= '</div>';
  	$output .= '<div class="submit-container"><input value="'._t('btn', 'valid').'" class="submitbut" default="default" type="submit"></div>';
  	$output .= '<input name="rub" value="'.$_REQUEST['rub'].'" type="hidden">';
  	$output .= '</form>';
  	
  	echo $output;
  }
}

?>