<?php
/**
 * Indicator / SDI module
 * 
 * Indicator / SDI detail page
 * 
 * @package linea21\modules\sdi
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('sdi')) ReloadIndex('admin');
////////////

include_once("../dashboard/common.php");

$str = '$("#clone-indicator").on( "click", function () {
	alertify.set({
		labels : {
			ok: "'._t('divers', 'yes').'", cancel: "'._t('divers', 'no').'" }
	});
	alertify.confirm("'._t('sdi', 'clone_confirmation').'", function (e) {
		if (e) {
			window.location = $("#clone-indicator").attr("href");
		}
	});
	return false;
});';


footerAddInlineJS($str);


if(!isset($_GET['id']) && !isset($_POST['id'])) {
  $id="1";
} else {
  if(isset($_POST['id']))	$id=$_POST['id'];
  if(isset($_GET['id']))	$id=$_GET['id'];
}

// getting tags
include_once('../class/class.tag.php');
$otag = new tag();
$display_tags = empty_none($otag->getTags('indicator', $id, true));


$sdi_object= new sdi;





$req_sdii=SQL_getInfoSdi($id);
$result_sdii = $sql_object -> DBSelect($req_sdii);

// Do record exists?
if(!isset($result_sdii[0]['sdii_name'])) redirect_to('@module_default');

$req_sdir=SQL_getRules( $id, $sql_object, $ID=-1);
$result_r = $sql_object -> DBSelect($req_sdir);

$req_sdie=SQL_getEvaluation( $id, $sql_object, $ID=-1);
$result_e = $sql_object -> DBSelect($req_sdie);

$req_sdip=SQL_getProvider( $id, $sql_object, $ID=-1);
$result_p = $sql_object -> DBSelect($req_sdip);

$multipleclass = ($result_sdii[0]['sdii_value_type'] != 'multiple') ? 'invisible' : '';
$uniqueclass = ($result_sdii[0]['sdii_value_type'] != 'unique') ? 'invisible' : '';

$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_det_level="index.php?rub=level&amp;todo=det&amp;id=";
$link_sup=$rub_link."&amp;todo=sup&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";
$link_clone="index.php?rub=sdi&amp;todo=clone&amp;id=";
$link_values="index.php?rub=dashboard&amp;todo=det&amp;scale_id=1&amp;id=";
$link_mod_e=$rub_link."&amp;todo=mod_e&amp;id=";
$link_mod_r=$rub_link."&amp;todo=mod_r&amp;id=";
$link_mod_p=$rub_link."&amp;todo=mod_p&amp;id=";
$navtitle=_t('sdi','det')." : ".$result_sdii[0]['sdii_name'];

$level = formatText($result_sdii[0]['level_name'], '2HTML');
$level_label_att = formatText($result_sdii[0]['level_label'] . ' : ' . $result_sdii[0]['level_name'], '2ATT');
$level_label = '<span class="level-label">' .formatText($result_sdii[0]['level_label'], '2HTML'). '</span> ';
if(defined('DISPLAY_LEVEL_LABEL') && DISPLAY_LEVEL_LABEL == 1) $disp_level_name = "<a href=\"".$link_det_level.$result_sdii[0]['sdii_level']."\" title=\"".$level_label_att."\">".$level_label . $level."</a>"; else $disp_level_name = "<a href=\"".$link_det_level.$result_sdii[0]['sdii_level']."\" title=\"".$level_label_att."\">" . $level."</a>";
if($result_sdii[0]['sdii_level'] == 0) $disp_level_name = _t('sdi', 'no_associated_level') . ' <span class="hint--bottom hint--large hint--rounded" aria-label="'. formatText(_t('sdi', 'no_associated_level_notice'), '2ATT') . '"><i class="fa fa-info-circle" aria-hidden="true"></i></span>'; // if no associated label

($result_sdii[0]['sdii_api_enabled'] == 'Y') ? $api = ' <span class="hint--top hint--rounded" aria-label="'._t('sdi', 'api-enabled').'"><i class="api-plugged active fa fa-code-fork" aria-hidden="true"></i></span>' : $api ='';
($result_sdii[0]['sdii_api_enabled'] == 'N' && !empty($result_sdii[0]['sdii_api_url'])) ? $api = ' <span class="hint--top hint--rounded" aria-label="'._t('sdi', 'api-disabled').'"><i class="api-plugged inactive fa fa-code-fork" aria-hidden="true"></i></span>' : $api = $api;


if ($result_sdii[0]['sdii_to_dashboard']=='Y') $display_attached_to_dashboard = _t('divers','yes');
else $display_attached_to_dashboard = _t('divers','no');
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','sdi')?></a></li>
	<li><span><?php echo formatnavTitle($navtitle);?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2($result_sdii[0]['sdii_name']) . $api;?></h2>

<!--  Unique value export -->
<form id="report" action="../export/report.php" method="post" class="visually-hidden">
<input type="hidden" name="what" value="dashboard">
<input type="hidden" name="quick_export" value="1">
<input type="hidden" name="scale" value="all">
<input type="hidden" name="sdi" value="det">
<input type="hidden" name="eachsdi[]" value="<?php echo $id; ?>">
<input type="hidden" name="provider" value="1">
<input type="hidden" name="reglementation" value="1">
<input type="hidden" name="evaluation" value="1">
<input type="hidden" name="format_report" value="word"><!-- pdf / word / html -->
<input type="hidden" name="sauver" value="1">
</form>
<!-- dropdown container -->
<div class="dropdown export-button">
<!-- trigger button -->
<button><i class="fa fa-download" aria-hidden="true"></i></i> <?php echo _t('export', 'action'); ?></button>
    <!-- dropdown menu -->
    <ul class="dropdown-menu">
        <li><a href="#report" data-format="pdf"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></i> <?php echo _t('export', 'format', 'pdf'); ?></a></li>
        <li><a href="#report" data-format="word"><i class="fa fa-file-word-o" aria-hidden="true"></i></i> <?php echo _t('export', 'format', 'word'); ?></a></li>
        <li><a href="#report" data-format="html"><i class="fa fa-html5" aria-hidden="true"></i></i> <?php echo _t('export', 'format', 'html'); ?></a></li>
    </ul>
</div>
<script>
$( "div.export-button li a" ).click(function() {
	var format = $(this).attr('data-format');
	$( "#report input[name=format_report]").val(format);
  $( "#report" ).submit();
  return false;
});
</script>

<?php echo "<a href=\"".$link_sup.$id."\" title=\""._t('sdi','sup')."\" class=\"ico_sup2\">";?><i class="fa fa-trash"></i><span><?php echo _t('sdi','sup'); ?></span></a>
<?php echo "<a href=\"".$link_mod.$id."\" title=\""._t('sdi','mod')."\" class=\"ico_mod2\">";?><i class="fa fa-pencil-square-o"></i><span><?php echo _t('sdi','mod'); ?></span></a>
<?php echo "<a href=\"".$link_clone.$id."\" title=\""._t('sdi','clone')."\" class=\"ico_generic2\" id=\"clone-indicator\">";?><i class="fa fa-files-o" aria-hidden="true"></i><span><?php echo _t('sdi','clone'); ?></span></a>
<?php echo "<a href=\"".$link_values.$id."\" title=\""._t('dashboard','det')."\" class=\"ico_generic2 no-action\">";?><i class="fa fa-line-chart" aria-hidden="true"></i><span><?php echo _t('sdi','see_values'); ?></span></a>

<dl class="dl2">
	<dt><?php echo mb_ucfirst(_t('sdi','level')) ?> :</dt>
    <dd><?php echo mb_ucfirst($disp_level_name); ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','name2')) ?> :</dt>
	<dd><?php echo formatText(mb_ucfirst($result_sdii[0]['sdii_name']), '2HTML');?></dd>
	
	<dt><?php echo mb_ucfirst(_t('sdi','type')) ?> : </dt>
	<dd><?php echo formatText(mb_ucfirst($lang['sdi']['select_type'][$result_sdii[0]['sdii_type']]), '2HTML');?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','nature')) ?> : </dt>
	<dd><?php echo formatText(mb_ucfirst($lang['sdi']['select_nature'][$result_sdii[0]['sdii_nature']]), '2HTML');?></dd>
	
	<dt><?php echo mb_ucfirst(_t('sdi','dashboard_viz')) ?> : </dt>
	<dd><?php echo formatText(mb_ucfirst($lang['sdi']['select_dashboard_viz'][$result_sdii[0]['sdii_dashboard_viz']]), '2HTML');?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','detail_viz')) ?> : </dt>
	<dd><?php echo formatText(mb_ucfirst($lang['sdi']['select_detail_viz'][$result_sdii[0]['sdii_detail_viz']]), '2HTML');?></dd>
    <dt><?php echo mb_ucfirst(_t('sdi','chart_force_min')) ?> : </dt>
    <dd>
        <?php
        echo $result_sdii[0]['sdii_force_chart_min'] == 'novalue' ?  _t('divers', 'no') : _t('divers', 'yes') . ' ('. cast_number($result_sdii[0]['sdii_force_chart_min']) . ')';
        ?>
    </dd>
	<dt><?php echo mb_ucfirst(_t('sdi','colors')) ?> : </dt>
	<dd><?php echo '<div class="mbs">' .get_html_colorbox($result_sdii[0]['sdii_mcolor']) . _t('dashboard','value') . '</div><div class="mbs">' . get_html_colorbox($result_sdii[0]['sdii_tcolor']). _t('dashboard','threshold_value').'</div>'; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','value_type')) ?> : </dt>
	<dd><?php echo formatText(mb_ucfirst($lang['sdi']['select_value_type'][$result_sdii[0]['sdii_value_type']]), '2HTML');?></dd>
    <div class="<?php echo $multipleclass; ?>">
        <dt><?php echo mb_ucfirst(_t('sdi','multiple_type')) ?> : </dt>
        <dd><?php echo formatText(mb_ucfirst($lang['sdi']['select_multiple_type'][$result_sdii[0]['sdii_multiple_type']]), '2HTML');?></dd>
        <dt><?php echo mb_ucfirst(_t('sdi','multiple_mode')) ?> : </dt>
        <dd><?php echo formatText(mb_ucfirst($lang['sdi']['select_multiple_mode'][$result_sdii[0]['sdii_multiple_mode']]), '2HTML');?></dd>
    </div>
    <div class="<?php echo $uniqueclass; ?>">
        <dt><?php echo mb_ucfirst(_t('sdi','multiple_mode')) ?> : </dt>
        <dd><?php echo formatText(mb_ucfirst($lang['sdi']['select_unique_mode'][$result_sdii[0]['sdii_unique_mode']]), '2HTML');?></dd>
    </div>
	<?php /*
	<dt><?php echo mb_ucfirst(_t('sdi','range')) ?> : </dt>
	<dd><?php echo formatText($result_sdii[0]['sdii_range'], '2HTML');?></dd>
	*/ ?>
	<dt><?php echo mb_ucfirst(_t('sdi','description')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_sdii[0]['sdii_description'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','goal')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_sdii[0]['sdii_goal'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','consulting')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_sdii[0]['sdii_consulting'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','attached_to_dashboard')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($display_attached_to_dashboard, '2HTML'));?></dd>
    <dt><?php echo mb_ucfirst(_t('sdi','input_instructions')) ?> :</dt>
    <dd><?php echo empty_nc(formatText($result_sdii[0]['sdii_input_instructions'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('tag','name')); ?></dt>
	<dd><?php echo $display_tags; ?></dd>
	
	<dt><?php echo mb_ucfirst(_t('sdi','threshold_relative')) ?> :</dt>
	<dd>
	<?php
	if ($result_sdii[0]['sdii_threshold_relative']=='Y') echo _t('sdi','threshold_relative_Y');
	else echo _t('sdi','threshold_relative_N');
	?>
	</dd>
	<dt><?php echo mb_ucfirst(_t('sdi','comment')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_sdii[0]['sdii_comment'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('divers','statut')) ?> :</dt>
	<dd><?php echo display_statut($result_sdii[0]['sdii_statut']);?></dd>
	<dt><?php echo mb_ucfirst(_t('dashboard','associated_projects')) ?> :</dt>
	<dd><?php echo get_associated_projects($id); ?></dd>

</dl>
<br class="brendstep" />
<h2><?php echo _t('sdi','info_mesure'); ?></h2>

<?php 
// seting default values
$display_min = empty_nc(fnumber_format($result_sdii[0]['sdii_min_value'], 'auto', false));
$display_max = empty_nc(fnumber_format($result_sdii[0]['sdii_max_value'], 'auto', false));
$display_threshold = empty_none(fnumber_format($result_sdii[0]['sdii_threshold_value'], 'auto', false));
$display_frequency = fnumber_format($result_sdii[0]['sdii_frequency'], 'auto', false);

// If indicator is boolean
if($result_sdii[0]['sdii_type'] == 'boolean' || $result_sdii[0]['sdii_type'] == 'qualitative') {
	$a = getBooleanValues($result_sdii[0]);
	if($a) {
		$index = array();
		foreach ($a as $key => $value) {
			array_push($index, $key);
		}
	
		$display_min = $a[min($index)];
		$display_max = $a[max($index)];
		if(is_null($result_sdii[0]['sdii_threshold_value'])) $display_threshold = empty_none('');
		else $display_threshold = $a[$result_sdii[0]['sdii_threshold_value']];
	
	}
}
?>
<br class="brendstep" />
<table>
	<thead>
		<tr>
		<?php
		echo "<td>".mb_ucfirst(_t('sdi','min_value'))." (".$result_sdii[0]['sdii_unit'].")"."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','max_value'))." (".$result_sdii[0]['sdii_unit'].")"."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','initial_threshold_value'))." (".$result_sdii[0]['sdii_unit'].")"."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','frequency'))."</td>\n";
		?>
		</tr>
	</thead>
	<tbody>
	<?php 
	echo "<tr>\n";
	echo "<td>". $display_min ."</td>\n";
	echo "<td>". $display_max ."</td>\n";
	echo "<td>". $display_threshold ."</td>\n";
	echo "<td>". $display_frequency ."</td>\n";
	echo "</tr>\n";
	?>
	</tbody>
</table>
<br class="brendstep" />

<?php 
if ($result_sdii[0]['sdii_api_enabled']=='Y') $display_api_enabled = _t('divers','yes');
else $display_api_enabled = _t('divers','no');
if ($result_sdii[0]['sdii_api_getvalues']=='Y') $display_api_getvalues = _t('divers','yes');
else $display_api_getvalues = _t('divers','no');
$display_api_url = formatText(empty_nc($result_sdii[0]['sdii_api_url']), '2HTML');
$display_api_decimal = ' (' . _t('sdi','api-decimal') . ' : ' . formatText($result_sdii[0]['sdii_api_decimal'], '2HTML').')';
if(Stringy\Stringy::create($display_api_url, CHARSET)->isUrl()) $display_api_url = sprintf('<a href="%s" target="_blank">%s</a>', $display_api_url, $display_api_url);

$display_api_datefield = formatText(empty_nc($result_sdii[0]['sdii_api_datefield']), '2HTML');
$display_api_valuefield = formatText(empty_nc($result_sdii[0]['sdii_api_valuefield']), '2HTML');

if($result_sdii[0]['sdii_value_type'] == 'multiple') {
    $form_api_multimapping = unserialize($result_sdii[0]['sdii_api_multimapping']);
    $form_api_multimapping_field = '';

    if(is_array($form_api_multimapping)) {
        foreach ($form_api_multimapping as $k => $v) {
            $form_api_multimapping_field .= '<div class="mapping-fields">';
            $form_api_multimapping_field .= '<span>'.mb_ucfirst($k). ' ⬌ '. $v. '</span>';
            $form_api_multimapping_field .= '</div>';
        }
    }
    $display_api_valuefield = $form_api_multimapping_field;
}
if ($result_sdii[0]['sdii_api_overwritevalues']=='Y') $display_overwrite_values = _t('divers','yes');
else $display_overwrite_values = _t('divers','no');
?>

<?php if ($result_sdii[0]['sdii_api_enabled']=='Y') { ?>
<div class="toggle_title">
	<a id="affprovider" href="#" title="<?php echo _t('sdi','api');?>"><?php echo _t('sdi','api');?></a>
</div>
<div id="api-infos" style="display: none;" class="mtm">
    <?php
    if(!defined('API_RETRIEVE') || API_RETRIEVE == 0) echo '<p class="error">'._t('sdi', 'api-globally-disabled').'</p>';
    ?>
<dl>
	<dt><?php echo mb_ucfirst(_t('sdi','api-enabled')) ?> :</dt>
	<dd><?php echo $display_api_enabled;?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','api-url')) ?> :</dt>
	<dd><?php echo $display_api_url;?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','api-date-field')) ?> :</dt>
	<dd><?php echo $display_api_datefield;?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','api-value-field')) ?> :</dt>
	<dd><?php echo $display_api_valuefield . $display_api_decimal; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','api-get-values')) ?> :</dt>
	<dd><?php echo $display_api_getvalues; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','api-get-values-since')) ?> :</dt>
	<dd><?php echo formatText(empty_nc($result_sdii[0]['sdii_api_getvalues_since'], 'HTML')); ?></dd>
    <dt><?php echo mb_ucfirst(_t('sdi','api-overwrite-values')); ?> :</dt>
    <dd><?php echo $display_overwrite_values; ?></dd>
</dl>
</div>
<?php } ?>

<div class="toggle_title">
	<a id="affprovider" href="#" title="<?php echo _t('sdi','aff_sdi_p');?>"><?php echo _t('sdi','aff_sdi_p');?></a>
</div>
<div id="provider" style="display: none;" class="mtm"><?php if ($result_p[0]['sdip_name']=="") {
  echo "<h2 class=\"info\">"._t('sdi','noresultp')."</h2>"
		   ?> <?php echo "<a href=\"".$link_mod_p.$id."\" title=\""._t('sdi','modify_sdi_p')."\" class=\"ico_mod2\">";?><i class="fa fa-pencil-square-o"></i><span><?php echo _t('sdi','modify_sdi_p'); ?></span></a>

  <?php } else { ?>
<h2><?php echo formatTitleh2($result_p[0]['sdip_name']);?></h2>

  <?php echo "<a href=\"".$link_mod_p.$id."\" title=\""._t('sdi','modify_sdi_p')."\" class=\"ico_mod2\">";?><i class="fa fa-pencil-square-o"></i><span><?php echo _t('sdi','modify_sdi_p'); ?></span></a>

<dl class="dl2">
	<dt><?php echo mb_ucfirst(_t('sdi','p_service')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_p[0]['sdip_service'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_incharge')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_p[0]['sdip_incharge'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_address')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_p[0]['sdip_address'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_phone')) ?> :</dt>
	<dd class="phone-format"><?php echo empty_nc(formatText($result_p[0]['sdip_phone'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_fax')) ?> :</dt>
	<dd class="phone-format"><?php echo empty_nc(formatText($result_p[0]['sdip_fax'], '2HTML'));?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_email')) ?> :</dt>
	<dd><?php echo "<a href=\"mailto:".$result_p[0]['sdip_email']."\" title=\"".formatText($result_p[0]['sdip_email'], '2HTML')."\" >".formatText($result_p[0]['sdip_email'], '2HTML')."</a>"; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_description')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_p[0]['sdip_description'], '2HTML'));?></dd>
</dl>
  <?php } ?></div>
<br class="brendstep" />


<div class="toggle_title">
	<a id="affeval" href="#"title="<?php echo _t('sdi','aff_sdi_e');?>"><?php echo _t('sdi','aff_sdi_e');?></a>
</div>
<div id="evaluation" style="display: none;" class="mtm"><br class="brendstep" />
  <?php echo "<a href=\"".$link_mod_e.$id."\" title=\""._t('sdi','modify_sdi_e')."\" class=\"ico_mod2\">";?><i class="fa fa-pencil-square-o"></i><span><?php echo _t('sdi','modify_sdi_e'); ?></span></a>
<br class="brendstep" />
<table>
	<thead>
		<tr>
		<?php
		echo "<td>".mb_ucfirst(_t('sdi','e_scale_compare'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','e_fiability'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','e_accessibility'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','e_lisibility'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','e_relevance'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','e_global_performance'))."</td>\n";
		?>
		</tr>
	</thead>
	<tbody>
	<?php echo "<tr>\n";
	echo "<td>". zero_asNC($result_e[0]['sdie_scale_compare'])."</td>\n";
	echo "<td>". zero_asNC($result_e[0]['sdie_fiability'])."</td>\n";
	echo "<td>". zero_asNC($result_e[0]['sdie_accessibility'])."</td>\n";
	echo "<td>". zero_asNC($result_e[0]['sdie_lisibility'])."</td>\n";
	echo "<td>". zero_asNC($result_e[0]['sdie_relevance'])."</td>\n";
	echo "<td>". zero_asNC($result_e[0]['sdie_global_performance'])."</td>\n";
	echo "</tr>\n";
	?>
	</tbody>
</table>
</div>
<br class="brendstep" />


<div class="toggle_title">
	<a href="#affreg" id="affreg" title="<?php echo _t('sdi','aff_sdi_r');?>"><?php echo mb_ucfirst(_t('sdi','aff_sdi_r'));?></a>
</div>
<div id="reglementation" style="display: none;" class="mtm"><?php if ($result_r[0]['sdir_title']=="") {
  echo "<h2 class=\"info\">"._t('sdi','noresultr')."</h2>"
		?> <?php echo "<a href=\"".$link_mod_r.$id."\" title=\""._t('sdi','modify_sdi_r')."\" class=\"ico_mod2\">";?><i class="fa fa-pencil-square-o"></i><span><?php echo _t('sdi','modify_sdi_r'); ?></span></a>

  <?php } else { ?>

<h2><?php echo empty_nc(formatTitleh2($result_r[0]['sdir_title']));?></h2>

<?php echo "<a href=\"".$link_mod_r.$id."\" title=\""._t('sdi','modify_sdi_r')."\" class=\"ico_mod2\">";?><i class="fa fa-pencil-square-o"></i><span><?php echo _t('sdi','modify_sdi_r'); ?></span></a>

<dl class="dl2">
	<dt><?php echo mb_ucfirst(_t('sdi','r_referer_uri')) ?> :</dt>
	<dd>
	<?php
	if ($result_r[0]['sdir_referer_uri']<>"") echo "<a href=\"".formatText($result_r[0]['sdir_referer_uri'], '2HTML')."\" title=\"".empty_nc(formatText($result_r[0]['sdir_mask_uri'], '2ATT'))."\" >".empty_nc(formatText($result_r[0]['sdir_mask_uri'], '2HTML'))."</a>";

	else echo "<dd>".empty_nc(formatText($result_r[0]['sdir_mask_uri'], '2HTML'));
	?>
	</dd>
	<dt><?php echo mb_ucfirst(_t('sdi','r_body')) ?> :</dt>
	<dd><?php echo empty_nc(formatText($result_r[0]['sdir_body'], '2HTML')); ?></dd>
</dl>

	<?php } ?> <br class="brendstep" />
</div>
<?php 
if(U_L == 'fr') {
	footerAddJS('../lib/js/jquery-mask-plugin/dist/jquery.mask.min.js');
	footerAddInlineJS("
 		$( '.phone-format').each(function( index ) {
	  if($(this).text() != '".empty_nc('')."') $(this).mask('00 00 00 00 00');
	});");
}
?>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->