<?php
/**
 * Indicator / SDI module - modify indicator main information
 * 
 * Modify given main information indicator from back-office
 * 
 * @package linea21\modules\sdi
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('sdi')) ReloadIndex('admin');
////////////

if(defined('API_RETRIEVE') && API_RETRIEVE == 1) $apiclass = 'api-container-enabled';
else $apiclass = 'api-container-disabled';

include_once('../class/class.tag.php');
include_once("../dashboard/common.php");

// TextboxList CSS/JS inclusion
addDynamicCSS(THEME_ADMIN_PATH.'css/TextboxList.css');
addDynamicCSS(THEME_ADMIN_PATH.'css/TextboxList.Autocomplete.css');
footerAddJS('../lib/js/TextboxList-jQuery/Source/GrowingInput.js');
footerAddJS('../lib/js/TextboxList-jQuery/Source/TextboxList.js');
footerAddJS('../lib/js/TextboxList-jQuery/Source/TextboxList.Autocomplete.js');
unit_javascript_validation();
api_multivalue_javascript();

include_once("../lib/input_helpers.php");
include_once(override('../level/mysql.inc.php', THEME_ADMIN_PATH));

if(!isset($_GET['id']) && !isset($_POST['id'])) {
  $id="1";
} else {
  if(isset($_REQUEST['id']))	$id=$_REQUEST['id'];
}

$link_mod_e=$rub_link."&amp;todo=mod_e&amp;id=";
$link_mod_r=$rub_link."&amp;todo=mod_r&amp;id=";
$link_mod_p=$rub_link."&amp;todo=mod_p&amp;id=";

// we get available tags list to display to user when hovering 'tags' label
$alltags = new tag();
$availableTags = $alltags->getTags('indicator', -1, false, ',', true);
$tags_list = '';
if(count($availableTags) > 0) {
	$l = '';
	foreach($availableTags as $item) {
		$l .= '<span class="tag">'.$item['tag_name'].'</span>';
	}
	$tags_list = '<div class="tags-list">'.$l.'</div>';
}

// getting tags from given project
$otag = new tag();
$form_tags = $otag->getTags('indicator', $id, true);


if (isset($_POST['enregistrer'])) {

  $data_table = unserialize(urldecode($_POST['data_table']));
  $sdi_object= new sdi;

  $result=$sdi_object->ModifySdi($id, $data_table, $sql_object);
  
  if($result) {
  	$otag->modifyTags('indicator', $id, $data_table['tags']);
  }

    // finally, we import initial values if asked
    if($result && $data_table['api-get-values'] == 'Y') {
        $sdi = $sql_object->DBSelect(SQL_getInfoSdi($id));
        api_update_indicators($sdi, true);
        if($r < 3) $sdi_object->setInitialImportDone($id, $sql_object);
    }
  
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$id;
  if(isset($result)) {
      header("Location: ".safe_redirect($link_confirm));
      exit;
  }
  else  system_error();
}

$sdi_object= new sdi;
$req_sdii=SQL_getInfoSdi($id);
$data_form_sdi = $sql_object -> DBSelect($req_sdii);

// Do record exists?
if(!isset($data_form_sdi[0]['sdii_name'])) redirect_to('@module_default');

$form_name = formatText($data_form_sdi[0]['sdii_name'], '2FIELD');
$form_level =  $data_form_sdi[0]['sdii_level'];
//$form_range =  $data_form_sdi[0]['sdii_range'];
$form_description =  formatText($data_form_sdi[0]['sdii_description'], '2FIELD');
$form_input_instructions = $data_form_sdi[0]['sdii_input_instructions'];
$form_comment =  formatText($data_form_sdi[0]['sdii_comment'], '2FIELD');
$form_goal =  formatText($data_form_sdi[0]['sdii_goal'], '2FIELD');
$form_consulting = formatText($data_form_sdi[0]['sdii_consulting'], '2FIELD');
$form_unit =  formatText($data_form_sdi[0]['sdii_unit'], '2FIELD');
$form_max_value =  $data_form_sdi[0]['sdii_max_value'];
$form_min_value =  $data_form_sdi[0]['sdii_min_value'];
$form_threshold_value = $data_form_sdi[0]['sdii_threshold_value'];
$form_frequency = $data_form_sdi[0]['sdii_frequency'];
$form_type = $data_form_sdi[0]['sdii_type'];
$form_nature = $data_form_sdi[0]['sdii_nature'];
$form_dashboard_viz = $data_form_sdi[0]['sdii_dashboard_viz'];
$form_detail_viz = $data_form_sdi[0]['sdii_detail_viz'];
$form_value_type = $data_form_sdi[0]['sdii_value_type'];
$form_multiple_type = $data_form_sdi[0]['sdii_multiple_type'];
$form_multiple_mode = $data_form_sdi[0]['sdii_multiple_mode'];
$form_unique_mode = $data_form_sdi[0]['sdii_unique_mode'];
$form_mcolor = $data_form_sdi[0]['sdii_mcolor']; // main value color
$form_tcolor = $data_form_sdi[0]['sdii_tcolor']; // threshold color


$form_force_min_value = ($data_form_sdi[0]['sdii_force_chart_min'] == 'novalue') ? 0 : cast_number($data_form_sdi[0]['sdii_force_chart_min']);

$form_api_url = $data_form_sdi[0]['sdii_api_url'];
$form_api_datefield = $data_form_sdi[0]['sdii_api_datefield'];
$form_api_valuefield = $data_form_sdi[0]['sdii_api_valuefield'];
$form_api_decimal = $data_form_sdi[0]['sdii_api_decimal'];
$form_api_values_since = $data_form_sdi[0]['sdii_api_getvalues_since'];

$form_api_multimapping = unserialize($data_form_sdi[0]['sdii_api_multimapping']);

// we overwrite values based on posted values if needed
if(isset($_POST['api-mapping'])) {
    $form_api_multimapping = [];
    for($i =0; $i < count($_POST['api-mapping']); $i++) {
        $form_api_multimapping[$_POST['api-mapping-i'][$i]] = $_POST['api-mapping'][$i];
    }
}

$form_api_multimapping_field = '';
$cnt=0;
if(is_array($form_api_multimapping)) {
    foreach ($form_api_multimapping as $k => $v) {
    // for($i = 0; $i < count($form_api_multimapping); $i++) {
        $form_api_multimapping_field .= '<p>';
        $form_api_multimapping_field .= '<label for="api-mapping-'.$cnt.'">'.mb_ucfirst($k).'</label><input name="api-mapping-i[]" type="hidden" id="api-mapping-i-"'.$cnt.'" value="'. $k .'" />';
        $form_api_multimapping_field .= '<input name="api-mapping[]" type="text" class="textfield api-child api-mapping-field" id="api-mapping-' .$cnt. '" maxlength="150" value="'. $v .'" />';
        $form_api_multimapping_field .= '</p>';
        $cnt++;
    }
}

if($data_form_sdi[0]['sdii_statut']=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
if($data_form_sdi[0]['sdii_statut']=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
if($data_form_sdi[0]['sdii_to_dashboard']=='Y')  $mask_dashboard="checked=\"checked\""; else $mask_dashboard='';
if($data_form_sdi[0]['sdii_force_chart_min']=='novalue')  $mask_force_min = ''; else $mask_force_min = 'checked="checked"';
if($data_form_sdi[0]['sdii_threshold_relative']=='Y')  $mask_threshold_relative="checked=\"checked\""; else $mask_threshold_relative='';
if($data_form_sdi[0]['sdii_api_enabled']=='Y')  $mask_api_enabled="checked=\"checked\""; else $mask_api_enabled='';
if($data_form_sdi[0]['sdii_api_getvalues']=='Y')  $mask_api_getvalues="checked=\"checked\""; else $mask_api_getvalues='';
if($data_form_sdi[0]['sdii_api_overwritevalues']=='Y')  $mask_api_overwrite="checked=\"checked\""; else $mask_api_overwrite='';

if (isset($_POST['valider'])) {

  $table = array();
  $table[0] = $_POST['sdi_name'];
  $table[1] = $_POST['description'];
  $table[2] = $_POST['comment'];
  $table[3] = $_POST['sdi_level'];
  //$table[4] = $_POST['range'];
  $table[4] = 0;
  $table[5] = $_POST['goal'];
  $table[6] = $_POST['consulting'];
  $table[7] = $_POST['unit'];
  $table[8] = $_POST['max_value'];
  $table[9] = $_POST['min_value'];
  $table[10]= $table['threshold_value'] = $_POST['threshold_value'];
  $table[11]= $_POST['frequency'];
  $table[12]= $_POST['sdi_statut'];
  $table['api-url'] = $_POST['api-url'];
  $table['api-date-field'] = $_POST['api-date-field'];
  $table['api-value-field'] = $_POST['api-value-field'];
  $table['api-decimal'] = $_POST['api-decimal'];
  $table['api-get-values-since'] = $_POST['api-get-values-since'];
  $table['input_instructions'] = $_POST['input_instructions'];

  $display_api_multimapping_field = '';
  if(isset($_POST['api-mapping'])) {
      $mapping = [];
      for($i =0; $i < count($_POST['api-mapping']); $i++) {
          $mapping[$_POST['api-mapping-i'][$i]] = $_POST['api-mapping'][$i];
          $display_api_multimapping_field .= '<div class="mapping-fields">';
          $display_api_multimapping_field .= '<span>'.mb_ucfirst($_POST['api-mapping-i'][$i]). ' ⬌ '. $_POST['api-mapping'][$i]. '</span>';
          $display_api_multimapping_field .= '</div>';
      }
      $table['api-multimapping'] = serialize($mapping);
  } else $table['api-multimapping'] = '';
  $table['value-type'] = $_POST['sdi_value_type']; // we pass value type for test

  if (isset($_POST['threshold_relative'])) {
      $table[13] = "Y";
  	$mask_threshold_relative="checked=\"checked\"";
  } else {
      $table[13] ="N";
  	$mask_threshold_relative="";
  }
  
  if (isset($_POST['attached_to_dashboard'])) {
  	$table[14]="Y";
  	$mask_dashboard="checked=\"checked\"";
  } else {
  	$table[14]="N";
  	$mask_dashboard="";
  }

  if (isset($_POST['sdi_force_min'])) {
        $table['chart_force_min'] = !is_numeric($_POST['sdi_force_min_value']) ? 0 : $_POST['sdi_force_min_value'];;
        $mask_force_min = "checked=\"checked\"";
        $form_force_min_value = !is_numeric($_POST['sdi_force_min_value']) ? 0 : $_POST['sdi_force_min_value'];
  } else {
        $table['chart_force_min'] = 'novalue';
        $mask_force_min = "";
  }
  
  // API forms fields handling
  if (isset($_POST['api-enabled'])) {
      $table['api-enabled']="Y";
      $mask_api_enabled="checked=\"checked\"";
  } else {
      $table['api-enabled']="N";
      $mask_api_enabled="";
  }
  if (isset($_POST['api-get-values'])) {
      $table['api-get-values']="Y";
      $mask_api_getvalues="checked=\"checked\"";
  } else {
      $table['api-get-values']="N";
      $mask_api_getvalues="";
  }
  if (isset($_POST['api-overwrite-values'])) {
      $table['api-overwrite-values']="Y";
      $mask_api_overwrite = "checked=\"checked\"";
  } else {
      $table['api-overwrite-values']="N";
      $mask_api_overwrite = "";
  }
  $table[15]=$_POST['sdi_type'];
  isset($_POST['sdi_dashboard_viz']) ? $table[16] = $table['dashboard_viz'] = $_POST['sdi_dashboard_viz'] : $table[16]  = $table['dashboard_viz'] = 'raw'; // a bug can happen when switching from quantitative to qualitative
  $table[17]=$_POST['sdi_detail_viz'];
  $table[18]=$_POST['sdi_value_type'];
  $table['multiple_type']=$_POST['sdi_multiple_type'];
  $table['multiple_mode']=$_POST['sdi_multiple_mode'];
  $table['unique_mode']=$_POST['sdi_unique_mode'];
  $table['tags']=$_POST['tags'];
  $table['nature']=$_POST['sdi_nature'];
  $table['mcolor']=$_POST['sdi_mcolor'];
  $table['tcolor']=$_POST['sdi_tcolor'];

  $sdi_object = new sdi;
  $integrity = $sdi_object -> CheckDataIntegrity_info($table, true, 'nature');

  $form_nature = $_POST['sdi_nature'];
  $form_type = $_POST['sdi_type'];
  isset($_POST['sdi_dashboard_viz']) ? $form_dashboard_viz=$_POST['sdi_dashboard_viz'] : $form_dashboard_viz='raw'; // a bug can happen when switching from quantitative to qualitative
  $form_detail_viz = $_POST['sdi_detail_viz'];
  $form_value_type = $_POST['sdi_value_type'];
  $form_multiple_type = $_POST['sdi_multiple_type'];
  $form_multiple_mode =$_POST['sdi_multiple_mode'];
  $form_unique_mode =$_POST['sdi_unique_mode'];
  $form_name = formatText($_POST['sdi_name'], '2FIELD');
  $form_level = $_POST['sdi_level'];
  $form_statut =$_POST['sdi_statut'];
  //$form_range = $_POST['range'];
  $form_description = formatText($_POST['description'], '2FIELD');
  $form_comment = formatText($_POST['comment'], '2FIELD');
  $form_goal = formatText($_POST['goal'], '2FIELD');
  $form_consulting = formatText($_POST['consulting'], '2FIELD');
  $form_unit = formatText($_POST['unit'], '2FIELD');
  $form_max_value = $_POST['max_value'];
  $form_min_value = $_POST['min_value'];
  $form_threshold_value = $_POST['threshold_value'];
  $form_threshold_relative=$table[13];
  $form_frequency = $_POST['frequency'];
  $form_tags = $_POST['tags'];
  $form_mcolor = $_POST['sdi_mcolor'];
  $form_tcolor = $_POST['sdi_tcolor'];
  
  $form_api_url = formatText($_POST['api-url'], '2FIELD');
  $form_api_datefield = formatText($_POST['api-date-field'], '2FIELD');
  $form_api_valuefield = formatText($_POST['api-value-field'], '2FIELD');
  $form_api_decimal = formatText($_POST['api-decimal'], '2FIELD');
  $form_api_values_since = formatText($_POST['api-get-values-since'], '2FIELD');
  $form_input_instructions = formatText($_POST['input_instructions'], '2FIELD');

  if($form_statut=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($form_statut=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';

  $table = urlencode(serialize($table));

}

// select-box des niveaux
$data=$sql_object->DBSelect(SQL_getLevelsList());
$select_level=LevelSelectBox($data, "sdi_level", $form_level);

$select_nature=selectBox($lang['sdi']['select_nature'], "sdi_nature", $form_nature);
$select_type=selectBox($lang['sdi']['select_type'], "sdi_type", $form_type);
$select_dashboard_viz = selectBox($lang['sdi']['select_dashboard_viz'], "sdi_dashboard_viz", $form_dashboard_viz, INDICATOR_DASHBOARD_VIZ);
$select_detail_viz = selectBox($lang['sdi']['select_detail_viz'], "sdi_detail_viz", $form_detail_viz);
$select_value_type = selectBox($lang['sdi']['select_value_type'], "sdi_value_type", $form_value_type);
$select_multiple_type = selectBox($lang['sdi']['select_multiple_type'], "sdi_multiple_type", $form_multiple_type);
$select_multiple_mode = selectBox($lang['sdi']['select_multiple_mode'], "sdi_multiple_mode", $form_multiple_mode);
$select_unique_mode = selectBox($lang['sdi']['select_unique_mode'], "sdi_unique_mode", $form_unique_mode);

$req_list_sdiname=SQL_getOnesdiname($id);
$data_sdi_name = $sql_object -> DBSelect($req_list_sdiname);
$navtitle=_t('sdi','mod')." : ".$data_sdi_name[0]['sdii_name'];
?>
<div id="chemin">
  <ul>
  	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
  	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','sdi')?></a></li>
  	<li><span><?php echo formatnavTitle($navtitle) ?></span></li>
  </ul>
</div>
<?php
if (!isset($integrity) || is_string($integrity)) {
	?>
	
	<script>
	$(document).ready( function() {

		$('#api-enabled').change(function() {
			if($(this).is(":checked")) $( ".api-child" ).prop( "readonly", false );
			else $( ".api-child" ).prop( "readonly", true );
		}); 
		$("#api-enabled").trigger("change");

		$("div.see-tags").hover(
			function() {
				$('.tags-list', this).fadeIn();
			},
			function() {
				$('.tags-list', this).hide();
		});
				
		// Autocomplete initialization
		var t1 = new $.TextboxList('#tags', {unique: true, plugins: {autocomplete: {onlyFromValues: false, placeholder:"<?php echo _t('textbox_js', 'placeholder')?>"}}});
		
		$.ajax({url: '../admin/_ajax_tag_autocomplete.php', dataType: 'json', success: function(r){
			t1.plugins['autocomplete'].setValues(r);
		}});
				
		$("div.textboxlist").each(function() {
			$(this).append('<p class="soft-emphase"><?php echo _t('msg','textboxlist_notice') ?><\/p>');
		});

	});
	</script>
	
	<?php 
	$js = '
	$("#sdi_force_min").change(function() {
        if(this.checked) {
            $("#chart-min-value-cont").fadeIn();
        } else {
            $("#chart-min-value-cont").fadeOut();
        }
    });
    $("#sdi_force_min").change();
    
	$("#sdi_nature").change(function() {
		
	if($(this).val() == "boolean" || $(this).val() == "qualitative") {

 		if($(this).val() == "qualitative") var text = "'.sprintf(_t('sdi','qualindicator_notice'), '#attached_to_dashboard').'";
 		else var text = "'.sprintf(_t('sdi','boolindicator_notice'), '#attached_to_dashboard').'";
		
		$("#boolean-indic-notice").remove();
        if($("#sdi_dashboard_viz").val() == "sparkline") $("#sdi_dashboard_viz option[value=\'raw\']").attr("selected", "selected");
		$("#sdi_dashboard_viz option[value=\'sparkline\']").attr("disabled", "disabled");
		$("#sdi_nature").after("<span class=\"soft-emphase input-notice\" id=\"boolean-indic-notice\">" + text + "<\/span>");
		
	} else {
	
		$("#sdi_dashboard_viz option[value=\'sparkline\']").removeAttr("disabled");
		$("#boolean-indic-notice").remove();
	}
		
	});
	
	// we call the function on loading page
	$("#sdi_nature").change();

    $("#sdi_value_type").change(function() {
    
    let initialTypeVal = "'.$data_form_sdi[0]['sdii_value_type'].'";
    if($(this).val() != initialTypeVal) {
        // we perform a check to see if values are already stored. If so, we display a warning !!!!
        $.ajax({
            type: "POST",
            data: {check_values:"'.$id.'"},
            dataType: "json",
            url: "../dashboard/_ajax_actions.php?token='.SECRET_KEY.'",
            success: function(data){
             if(data.returnedValues > 0) alertify.error("'._t('sdi', 'warning_switch_type').'".replace("%s", data.returnedValues), 0);
            }
        });
	}
		
	if($(this).val() == "multiple") {

 		var text = "'.sprintf(_t('sdi','multipleindicator_notice'), '#attached_to_dashboard').'";
		
		$("#multiple-indic-notice").remove();	
		$("#sdi_value_type").after("<span class=\"soft-emphase input-notice\" id=\"multiple-indic-notice\">" + text + "<\/span>");
		$("#sdi_multiple_type_cont").fadeIn();
		$("#sdi_multiple_mode_cont").fadeIn();
		$("#sdi_unique_mode_cont").hide();
	} else {
		$("#multiple-indic-notice").remove();
		$("#sdi_multiple_type_cont").hide();
		$("#sdi_multiple_mode_cont").hide();
		$("#sdi_unique_mode_cont").fadeIn();
	}
		
	});
    // we call the function on loading page
    $("#sdi_value_type").change();
	';
	
	footerAddInlineJS($js);
	
?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if (isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<div class="mod_link">
<a href="<?php echo $link_mod_e.$id ;?>"><?php echo _t('sdi','modify_sdi_e');?></a>
<a href="<?php echo $link_mod_p.$id ;?>"><?php echo _t('sdi','modify_sdi_p');?></a>
<a href="<?php echo $link_mod_r.$id ;?>"><?php echo _t('sdi','modify_sdi_r');?></a>
</div>
<br class="brendstep" />
<h2><?php echo mb_ucfirst(_t('sdi','mod_title')); ?></h2>
<div class="subtitle" id="indicator-subtitle"><?php echo formatText($data_sdi_name[0]['sdii_name'], '2HTML'); ?></div>

<form id="addsdi" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p>
	<label for="sdi_name"><?php echo mb_ucfirst(_t('sdi','name2')) ?>&nbsp;:&nbsp;*</label>
	<input name="sdi_name" type="text" class="textfield" id="sdi_name" maxlength="400" value="<?php echo $form_name; ?>" required />
</p>

<p>
  	<label for="sdi_type"><?php echo mb_ucfirst(_t('sdi','type')) ?> : </label>
  	<?php echo $select_type; ?>
</p>

<p>
  	<label for="sdi_nature"><?php echo mb_ucfirst(_t('sdi','nature')) ?>&nbsp;:&nbsp;*</label>
  	<?php echo $select_nature; ?>
</p>

<p>
  	<label for="sdi_dashboard_viz"><?php echo mb_ucfirst(_t('sdi','dashboard_viz')) ?>&nbsp;:&nbsp;*</label>
  	<?php echo $select_dashboard_viz; ?>
</p>
<p>
  	<label for="sdi_detail_viz"><?php echo mb_ucfirst(_t('sdi','detail_viz')) ?>&nbsp;:&nbsp;*</label>
  	<?php echo $select_detail_viz; ?>
</p>
<div>
        <div class="label">
            <label for="sdi_force_min"><?php echo mb_ucfirst(_t('sdi','chart_force_min')) ?>&nbsp;:</label>
        </div>
        <div class="rightpanel">
            <input type="checkbox" class="switch" name="sdi_force_min" value="1" id="sdi_force_min" <?php echo $mask_force_min; ?> />
            <div id="chart-min-value-cont" style="display:inline-block">
                <label for="sdi_force_min_value" class="mll"><?php echo mb_ucfirst(_t('sdi','min_value')); ?></label>
                <input name="sdi_force_min_value" type="text"  class="shorttextfield w100p"  id="sdi_force_min_value" value="<?php echo $form_force_min_value; ?>" />
            </div>
        </div>
</div>
<div>
<div class="label"><?php echo mb_ucfirst(_t('sdi','colors')); ?> :</div>
    <div class="rightpanel">
      <input name="sdi_mcolor" type="color" id="sdi_mcolor" value="<?php echo $form_mcolor; ?>" required />
      <label for="sdi_mcolor" class="mrl"><?php echo mb_ucfirst(_t('dashboard','value')); ?></label>
      <input name="sdi_tcolor" type="color" id="sdi_tcolor" value="<?php echo $form_tcolor; ?>" required />
      <label for="sdi_tcolor"><?php echo mb_ucfirst(_t('dashboard','threshold_value')); ?></label>
    </div>
</div>
<p>
  	<label for="sdi_value_type"><?php echo mb_ucfirst(_t('sdi','value_type')) ?>&nbsp;:&nbsp;*</label>
  	<?php echo $select_value_type; ?>
</p>
<p id="sdi_multiple_type_cont">
    <label for="sdi_multiple_type"><?php echo mb_ucfirst(_t('sdi','multiple_type')) ?>&nbsp;:&nbsp;*</label>
    <?php echo $select_multiple_type; ?>
</p>
<p id="sdi_multiple_mode_cont">
    <label for="sdi_multiple_mode"><?php echo mb_ucfirst(_t('sdi','multiple_mode')) ?>&nbsp;:&nbsp;*</label>
    <?php echo $select_multiple_mode; ?>
</p>
<p id="sdi_unique_mode_cont">
    <label for="sdi_unique_mode"><?php echo mb_ucfirst(_t('sdi','multiple_mode')) ?>&nbsp;:&nbsp;*</label>
    <?php echo $select_unique_mode; ?>
</p>
<p>
	<label for="sdi_level"><?php echo mb_ucfirst(_t('sdi','level')) ?>&nbsp;:&nbsp;*</label>
	<?php echo $select_level; ?>
</p>
<div class="label"><?php echo mb_ucfirst(_t('divers','statut')); ?> : </div>
<div class="rightpanel">
	<input name="sdi_statut" type="radio" class="radio" id="statut_P" value="P" <?php echo $mask_statut_P; ?> required />
	<label for="statut_P"><?php echo mb_ucfirst(_t('statut','public')); ?></label>
	<input name="sdi_statut" type="radio" class="radio" id="statut_D" value="D" <?php echo $mask_statut_D; ?> />
	<label for="statut_D"><?php echo mb_ucfirst(_t('statut','draft')); ?></label>
</div>

<?php
/** <p>
<label for="range" ><?php echo mb_ucfirst(_t('sdi','range')) ?>&nbsp;:&nbsp;*</label>
<input name="range" type="text" class="textfield" id="range" maxlength="150" value="<?php echo $form_range;
?>" />
</p> */
?>
<p>
	<label for="description"><?php echo mb_ucfirst(_t('sdi','description')) ?>&nbsp;:&nbsp;*</label>
	<textarea id="description" name="description" <?php echo AREA_SETTINGS; ?> class="largetextfield" required><?php echo $form_description; ?></textarea>
</p>
<p>
	<label for="goal"><?php echo mb_ucfirst(_t('sdi','goal')) ?> :</label>
	<textarea id="goal" name="goal" <?php echo AREA_SETTINGS; ?> class="largetextfield"><?php echo $form_goal; ?></textarea>
</p>
<p>
	<label for="consulting"><?php echo mb_ucfirst(_t('sdi','consulting')) ?> :</label>
	<textarea id="consulting" name="consulting" <?php echo AREA_SETTINGS; ?> class="largetextfield"><?php echo $form_consulting; ?></textarea>
</p>
<p>
	<label for="attached_to_dashboard"><?php echo mb_ucfirst(_t('sdi','attached_to_dashboard')); ?> :</label>
	<input type="checkbox" class="switch" name="attached_to_dashboard" value="1" id="attached_to_dashboard" <?php echo $mask_dashboard; ?> />
</p>
<p class="mts">
    <label for="input_instructions"><?php echo mb_ucfirst(_t('sdi','input_instructions')) ?> :</label>
    <textarea id="input_instructions" name="input_instructions" <?php echo AREA_SETTINGS; ?> class="largetextfield"><?php echo $form_input_instructions; ?></textarea>
</p>
<div>
  <div class="see-tags label">
	<label for="tags"><i class="fa fa-tag" aria-hidden="true"></i> <?php echo mb_ucfirst(_t('tag','name')); ?> : </label>
	<?php echo $tags_list; ?>
  </div>
  <input name="tags" type="text" maxlength="800" id="tags" class="textfield" value="<?php echo $form_tags; ?>" />
</div>
<p>
	<label for="comment"><?php echo mb_ucfirst(_t('sdi','comment')) ?> :</label>
	<textarea id="comment" name="comment" <?php echo AREA_SETTINGS; ?> class="largetextfield"><?php echo $form_comment; ?></textarea>
</p>

<h3 class="part"><?php echo mb_ucfirst(_t('sdi','info_mesure')); ?></h3>

<p>
	<label for="unit"><?php echo mb_ucfirst(_t('sdi','unit')) ?>&nbsp;:&nbsp;*</label>
	<input name="unit" type="text" class="textfield" id="unit" maxlength="100" value="<?php echo $form_unit; ?>" required />
</p>
<p>
	<label for="min_value"><?php echo mb_ucfirst(_t('sdi','min_value')) ?> : </label>
	<input name="min_value" type="text" class="textfield" id="min_value" maxlength="100" value="<?php echo $form_min_value; ?>" />
</p>
<p>
	<label for="max_value"><?php echo mb_ucfirst(_t('sdi','max_value')) ?> : </label>
	<input name="max_value" type="text" class="textfield" id="max_value" maxlength="6" value="<?php echo $form_max_value; ?>" />
</p>
<p>
	<label for="threshold_value"><?php echo mb_ucfirst(_t('sdi','initial_threshold_value')) ?> : </label>
	<input name="threshold_value" type="text" class="textfield" id="threshold_value" maxlength="100" value="<?php echo $form_threshold_value; ?>" />
</p>
<p>
	<label for="frequency"><?php echo mb_ucfirst(_t('sdi','frequency')) ?>&nbsp;:&nbsp;*</label>
	<input name="frequency" type="text" class="textfield" id="frequency" maxlength="11" value="<?php echo $form_frequency; ?>" required />
</p>
<div class="label"><?php echo mb_ucfirst(_t('sdi','threshold_relative')) ?>&nbsp;:&nbsp;*</div>
<div class="rightpanel">
	<input type="checkbox" class="switch" name="threshold_relative" id="threshold_relative" <?php echo $mask_threshold_relative; ?> />
  <label for="threshold_relative"><?php echo _t('sdi','threshold_relative_comment') ?></label>
</div>

<div class="<?php echo $apiclass; ?>">
<h3 class="part"><?php echo mb_ucfirst(_t('sdi','api')); ?></h3>
<p class="mts">
	<label for="api-enabled"><?php echo mb_ucfirst(_t('sdi','api-enabled')); ?> :</label>
	<input type="checkbox" class="switch" name="api-enabled" value="1" id="api-enabled" <?php echo $mask_api_enabled; ?> />
</p>
<p>
	<label for="api-url"><?php if(!empty($form_api_url) && !empty($mask_api_enabled)) echo '<a href="#" id="reload-discover-api" title="'. mb_ucfirst(_t('sdi','api-discover')). '"><i class="fa fa-refresh" aria-hidden="true"></i></a>'; ?> <?php echo mb_ucfirst(_t('sdi','api-url')); ?> : </label>
	<input name="api-url" type="text" class="textfield api-child" id="api-url" value="<?php echo $form_api_url; ?>" />

</p>
<p>
	<label for="api-date-field"><?php echo mb_ucfirst(_t('sdi','api-date-field')); ?> :</label>
	<input name="api-date-field" type="text" class="textfield api-child" id="api-date-field" maxlength="150" value="<?php echo $form_api_datefield; ?>" />
</p>
<div  id="api-value-field-cont">
<p>
	<label for="api-value-field"><?php echo mb_ucfirst(_t('sdi','api-value-field')); ?> :</label>
	<input name="api-value-field" type="text" class="textfield api-child" id="api-value-field" maxlength="150" value="<?php echo $form_api_valuefield; ?>" />
</p>
</div>
<div id="api-multi-mapping-cont">
    <div class="label"><?php echo mb_ucfirst(_t('sdi','api-value-field')); ?> : </div>
    <?php echo $form_api_multimapping_field; ?>
</div>
<p>
	<label for="api-decimal"><?php echo mb_ucfirst(_t('sdi','api-decimal')); ?> :</label>
	<input name="api-decimal" type="number" class="api-child" id="api-decimal" min="0" max="5" step="1" value="<?php echo $form_api_decimal; ?>" />
</p>
<p class="mts">
	<label for="api-get-values"><?php echo mb_ucfirst(_t('sdi','api-get-values')); ?> :</label>
	<input type="checkbox" class="switch api-child" name="api-get-values" value="1" id="api-get-values" <?php echo $mask_api_getvalues; ?> />
</p>
<p>
	<label for="api-get-values-since"><?php echo mb_ucfirst(_t('sdi','api-get-values-since')); ?> :</label>
	<input name="api-get-values-since" type="text" class="textfield api-child" id="api-get-values-since" maxlength="100" value="<?php echo $form_api_values_since; ?>" />
</p>
<p class="mts">
    <label for="api-overwrite-values"><span class="hint--top hint--large hint--rounded" aria-label="<?php echo formatText(mb_ucfirst(_t('sdi', 'api-overwrite-values-notice')), '2ATT'); ?>"><i class="fa fa-info-circle" aria-hidden="true"></i></span> <?php echo mb_ucfirst(_t('sdi','api-overwrite-values')); ?> :</label>
    <input type="checkbox" class="switch" name="api-overwrite-values" value="1" id="api-overwrite-values" <?php echo $mask_api_overwrite; ?> />
</p>
</div>

<div>
  <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
  <?php echo cancel_button($rub_link."&amp;todo=det&amp;id=".$id); ?>
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
            // Récapitulatif
} else {
  if (!isset($integrity5) || is_string($integrity5)) {


    $table=unserialize(urldecode($table));

    $display_sdi_name = formatText(empty_nc($table[0]), '2HTML');
    $display_sdi_description =formatText(empty_nc($table[1]), '2HTML');
    $display_sdi_comment =formatText(empty_nc($table[2]), '2HTML');
    //$display_sdi_range = empty_nc($table[4]);
    $display_sdi_goal = formatText(empty_nc($table[5]), '2HTML');
    $display_sdi_consulting = formatText(empty_nc($table[6]), '2HTML');
    $display_sdi_unit = formatText(empty_nc($table[7]), '2HTML');
    $display_sdi_max_value = empty_nc(fnumber_format($table[8], 'auto', false));
    $display_sdi_min_value = empty_nc(fnumber_format($table[9], 'auto', false));
    $display_sdi_threshold_value = empty_none(fnumber_format($table[10], 'auto', false));
    $display_sdi_frequency = empty_nc(fnumber_format($table[11], 'auto', false));
    $display_sdi_statut = empty_nc($table[12]);
    $display_input_instructions =  empty_nc(formatText($table['input_instructions'], '2HTML')); // @todo
    $record=$sql_object->DBSelect(SQL_getoneLevel($table[3]));
    isset($record[0]['level_name']) ? $display_sdi_level=formatText($record[0]['level_name'], '2HTML') : $display_sdi_level= _t('sdi', 'no_associated_level'). ' <span class="hint--top hint--large hint--rounded" aria-label="'. formatText(_t('sdi', 'no_associated_level_notice'), '2ATT') . '"><i class="fa fa-info-circle" aria-hidden="true"></i></span>'; // if no associated label


    if ($table[13]=='Y') $display_sdi_threshold_relative = _t('sdi','threshold_relative_Y');
    else $display_sdi_threshold_relative = _t('sdi','threshold_relative_N');

    if ($table[14]=='Y') $display_attached_to_dashboard = _t('divers','yes');
    else $display_attached_to_dashboard = _t('divers','no');

    if($table['chart_force_min'] == 'novalue')  $display_f_chart_min = _t('divers', 'no');
    else $display_f_chart_min = _t('divers', 'yes') . ' ('. cast_number($table['chart_force_min']) . ')';

    $display_sdi_type = formatText($lang['sdi']['select_type'][$table[15]], '2HTML');
    $display_sdi_nature = formatText($lang['sdi']['select_nature'][$table['nature']], '2HTML');
    $display_sdi_dashboard_viz = formatText($lang['sdi']['select_dashboard_viz'][$table[16]], '2HTML');
    $display_sdi_detail_viz = formatText($lang['sdi']['select_detail_viz'][$table[17]], '2HTML');
    $display_sdi_value_type = formatText($lang['sdi']['select_value_type'][$table[18]], '2HTML');
    $display_sdi_multiple_type = formatText($lang['sdi']['select_multiple_type'][$table['multiple_type']], '2HTML');
    $display_sdi_multiple_mode = formatText($lang['sdi']['select_multiple_mode'][$table['multiple_mode']], '2HTML');
    $display_sdi_unique_mode = formatText($lang['sdi']['select_unique_mode'][$table['unique_mode']], '2HTML');
    $multipleclass = ($table[18] != 'multiple') ? 'invisible' : '';
    $uniqueclass = ($table[18] != 'unique') ? 'invisible' : '';


    if ($table['api-enabled']=='Y') $display_api_enabled = _t('divers','yes');
    else $display_api_enabled = _t('divers','no');
    if ($table['api-get-values']=='Y') $display_get_values = _t('divers','yes');
    else $display_get_values = _t('divers','no');
    if(trim($table['api-get-values-since']) != '') $display_get_values_since = $table['api-get-values-since'];
    else $display_get_values_since = empty_nc('');
    if ($table['api-overwrite-values']=='Y') $display_overwrite_values = _t('divers','yes');
    else $display_overwrite_values = _t('divers','no');
    
    $display_api_url = formatText(empty_nc($table['api-url']), '2HTML');
    $display_api_decimal = ' (' . _t('sdi','api-decimal') . ' : ' . formatText($table['api-decimal'], '2HTML').')';
    if(Stringy\Stringy::create($display_api_url, CHARSET)->isUrl()) $display_api_url = sprintf('<a href="%s" target="_blank">%s</a>', $display_api_url, $display_api_url);
    
    $display_api_datefield = formatText(empty_nc($table['api-date-field']), '2HTML');
    $display_api_valuefield = formatText(empty_nc($table['api-value-field']), '2HTML');

    if($table['value-type'] == 'multiple') $display_api_valuefield = $display_api_multimapping_field;

    $table = urlencode(serialize($table));

?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));

?>
<div id="content">
<h2><?php echo mb_ucfirst(_t('recap','title')); ?></h2>
<div class="subtitle" id="indicator-subtitle"><?php echo formatText($data_sdi_name[0]['sdii_name'], '2HTML'); ?></div>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('sdi','name2')); ?> :</dt>
	<dd><?php echo $display_sdi_name; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','type')) ?> : </dt>
	<dd><?php echo mb_ucfirst($display_sdi_type);?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','nature')) ?> : </dt>
	<dd><?php echo mb_ucfirst($display_sdi_nature);?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','dashboard_viz')) ?> : </dt>
	<dd><?php echo mb_ucfirst($display_sdi_dashboard_viz);?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','detail_viz')) ?> : </dt>
	<dd><?php echo mb_ucfirst($display_sdi_detail_viz);?></dd>
    <dt><?php echo mb_ucfirst(_t('sdi','chart_force_min')) ?> : </dt>
    <dd><?php echo $display_f_chart_min; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','colors')) ?> : </dt>
	<dd><?php echo '<div class="mbs">' .get_html_colorbox($form_mcolor) . _t('dashboard','value') . '</div><div class="mbs">' . get_html_colorbox($form_tcolor). _t('dashboard','threshold_value').'</div>'; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','value_type')) ?> : </dt>
    <dd><?php echo mb_ucfirst($display_sdi_value_type);?></dd>
    <div class="<?php echo $multipleclass; ?>">
        <dt><?php echo mb_ucfirst(_t('sdi','multiple_type')) ?> : </dt>
        <dd><?php echo mb_ucfirst($display_sdi_multiple_type);?></dd>
        <dt><?php echo mb_ucfirst(_t('sdi','multiple_mode')) ?> : </dt>
        <dd><?php echo mb_ucfirst($display_sdi_multiple_mode);?></dd>
    </div>
    <div class="<?php echo $uniqueclass; ?>">
        <dt><?php echo mb_ucfirst(_t('sdi','multiple_mode')) ?> : </dt>
        <dd><?php echo mb_ucfirst($display_sdi_unique_mode);?></dd>
    </div>
	<dt><?php echo mb_ucfirst(_t('divers','statut')); ?> :</dt>
	<dd><?php echo display_statut($display_sdi_statut); ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','level')); ?> :</dt>
	<dd><?php echo $display_sdi_level; ?></dd>
	<?php
	/*<dt><?php echo mb_ucfirst(_t('sdi','range')); 	?> :</dt>
	<dd><?php echo $display_sdi_range; ?><br /></dd> */
	?>
	<dt><?php echo mb_ucfirst(_t('sdi','description')); ?> :</dt>
	<dd><?php echo $display_sdi_description; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','goal')); ?> :</dt>
	<dd><?php echo $display_sdi_goal; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','consulting')); ?> :</dt>
	<dd><?php echo $display_sdi_consulting; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','attached_to_dashboard'));	?> :</dt>
	<dd><?php echo $display_attached_to_dashboard;	?></dd>
    <dt><?php echo mb_ucfirst(_t('sdi','input_instructions')) ?> :</dt>
    <dd><?php echo $display_input_instructions; ?></dd>
	<dt><?php echo mb_ucfirst(_t('tag','name')); ?> :</dt>
	<dd><?php echo empty_none(str_replace(',', ', ', $form_tags)); ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','comment')); ?> :</dt>
	<dd><?php echo $display_sdi_comment; ?></dd>
</dl>
<h3 class="part"><?php echo mb_ucfirst(_t('sdi','info_mesure')); ?></h3>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('sdi','unit')); ?> :</dt>
	<dd><?php echo $display_sdi_unit; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','min_value')); ?> :</dt>
	<dd><?php echo $display_sdi_min_value;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','max_value')); ?> :</dt>
	<dd><?php echo $display_sdi_max_value; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','initial_threshold_value'));	?> :</dt>
	<dd><?php echo $display_sdi_threshold_value; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','threshold_relative'));	?> :</dt>
	<dd><?php echo $display_sdi_threshold_relative;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','frequency')); ?> :</dt>
	<dd><?php echo $display_sdi_frequency;	?></dd>
</dl>

<div class="force-form-duplicate <?php echo $apiclass; ?>">
<h3 class="part"><?php echo mb_ucfirst(_t('sdi','api')); ?></h3>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('sdi','api-enabled')); ?> :</dt>
	<dd><?php echo $display_api_enabled; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','api-url')); ?> :</dt>
	<dd><?php echo $display_api_url;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','api-date-field')); ?> :</dt>
	<dd><?php echo $display_api_datefield; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','api-value-field'));	?> :</dt>
	<dd><?php echo $display_api_valuefield . $display_api_decimal; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','api-get-values'));	?> :</dt>
	<dd><?php echo $display_get_values;	?></dd>
	<?php if ($display_get_values == _t('divers','yes')) { ?>
	<dt><?php echo mb_ucfirst(_t('sdi','api-get-values-since')); ?> :</dt>
	<dd><?php echo $display_get_values_since;	?></dd>
	<?php } ?>
    <dt><?php echo mb_ucfirst(_t('sdi','api-overwrite-values')); ?> :</dt>
    <dd><?php echo $display_overwrite_values; ?></dd>
</dl>
</div>
<form id="addsdi5" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
  <div>
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
    <?php echo cancel_button($rub_link."&amp;todo=det&amp;id=".$id); ?>
    <input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
    <input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
    <input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="enregistrer" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
  }
}
?>