<?php
/**
 * System module
 * 
 * Perform basic actions using ajax
 * 
 * @package linea21\modules\system
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
$noplugin = true; // flag for ../config/define.php file
include_once('../config/define.php');
include_once('../languages/' . U_L . '/lang_common.' . CHARSET . '.php');
include_once('../languages/' . U_L . '/lang_system.' . CHARSET . '.php');

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

    
if(isset($_REQUEST['action'])) $action = $_REQUEST['action']; else die();

if($action == "version-check") {
    
    echo check4newVersion();
    exit();
}

if($action == "emailq-purge") {
    
    include_once('../class/class.emailq.php');
	
	$emailqo = new emailq;
	$r = $emailqo->purgeUnsent($sql_object);

	if( $r )  {
        echo '{"status":1, "msg": "'. formatText(_t('emailq', 'purge_success'), '2ATT') .'"}';
    } else {
        echo '{"status":0, "msg": "'._t('msg', 'action_failed').'"}';
    }
    exit();
}

if($action == "see-logs") {

    if(isset($_REQUEST['file'])) $file = $_REQUEST['file']; else die();
    
    $allowed_files = array_merge($l21config->config_params['LOGS_SETTINGS'], array('LOG_PHP_ERRORS' => '../logs/PHP_errors.log'));
    //print_r($allowed_files);
    
    if($file == 'LOG_PHP_ERRORS') {
        $filepath = SITE_PATH . str_replace('../', '', $allowed_files['LOG_PHP_ERRORS']);
    } else {
        $filepath = SITE_PATH . str_replace('../', '', $allowed_files[$file]);
    }

    // we ensure log file exists
    if(! array_key_exists ( $file , $allowed_files ) ) die('log file does not exists');

    echo '<h2 class="see-logs-title">'.sprintf(_t('logs', 'filename_access'), $file).'</h2>';
    echo '<div class="log-records">';
    if(!file_exists($filepath)) fopen($filepath, "w");
    
    $handle = fopen($filepath, "r");
    $ln = 1;
    if ($handle) {
        while (($line = fgets($handle)) !== false) {
            // process the line read.
            echo '<div class="flex-container"><div class="line-number">'.$ln.'</div><div class="log-record item-fluid">' . htmlentities($line, ENT_QUOTES, 'utf-8') . '</div></div>';
            $ln++;
        }
        
        fclose($handle);
    } else {
        // error opening the file.
        echo '<p class="info">Problem opening file.</p>';
    }
    echo '</div>';
    

}


if($action == "purge-log") {
    
    if(isset($_REQUEST['file'])) $file = $_REQUEST['file']; else die();
    
    $allowed_files = array_merge($l21config->config_params['LOGS_SETTINGS'], array('LOG_PHP_ERRORS' => '../logs/PHP_errors.log'));
    //print_r($allowed_files);
    
    if($file == 'LOG_PHP_ERRORS') {
        $filepath = SITE_PATH . str_replace('../', '', $allowed_files['LOG_PHP_ERRORS']);
    } else {
        $filepath = SITE_PATH . str_replace('../', '', $allowed_files[$file]);
    }
    
    $purge = file_put_contents($filepath, "");

    if( is_numeric($purge) )  {
        echo '{"status":1, "msg": "'. formatText(sprintf(_t('logs', 'purge_success'), $file), '2ATT') .'"}';
    } else {
        echo '{"status":0, "msg": "'._t('msg', 'action_failed').'"}';
    }
    exit();
}
?>