<?php
/**
 * System module - Ban IP edit
 *
 * Files edition in back-office
 * Available for themes (templates) and plugins
 *
 * @package linea21\core\system
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////
if(!isset($_REQUEST['todo']) || ($_REQUEST['todo'] != 'ban-ip-add' && $_REQUEST['todo'] != 'ban-ip-del' && $_REQUEST['todo'] != 'ban-ip-edit')) ReloadIndex('public');
if(isset($_REQUEST['id'])) $ip = sanitize_string(strip_input($_REQUEST['id']));
if($_REQUEST['todo'] == 'ban-ip-edit' && ( !isset($_REQUEST['token'])  || $_REQUEST['token'] != SECRET_KEY)) ReloadIndex('public');

$obanIP = new banIP();

if($_REQUEST['todo'] == 'ban-ip-add') {
    $r = $obanIP->add($ip, $GLOBALS['sql_object']);
    
    if(is_numeric($r)) {
        $_SESSION['banned_ip'] = $ip;
        header("Location: ".safe_redirect('confirm.php?rub=system&todo=ban-ip-add'));
        exit;
    }
    else  system_error();
}
if($_REQUEST['todo'] == 'ban-ip-del') {
    $r = $obanIP->delete($ip, $GLOBALS['sql_object']);
    
    if($r) {
        $_SESSION['banned_ip'] = $ip;
        header("Location: ".safe_redirect('confirm.php?rub=system&todo=ban-ip-del'));
        exit;
    }
    else  system_error();
}
if($_REQUEST['todo'] == 'ban-ip-edit') {

    if(isset($_POST['save'])) {
        $obanIP->updateBannedIP(strip_tags($_POST['banned-ips']));
    }
    $data = $obanIP->getBannedIP();
    $ips = '';
    foreach($data as $d) {
        $ips .= $d."\n";
    }
?>
<div id="chemin">
    <ul>
        <li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
        <li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','system')?> </a></li>
        <li><span><?php echo _t('system', 'banned_ip'); ?> </span></li>
    </ul>
</div>

<!--end barre haute -->
<div class="contentcontainer">
    <?php include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));?>
    <div id="content">
        <h2>
            <?php echo mb_ucfirst(_t('system', 'banned_ip')); ?>
        </h2>
        <?php
        // we display user message if needed
        if(isset($user_msg)) {
            echo '<p class="'.$user_msg['class'].'">'.$user_msg['msg'].'</p>';
        }
        ?>
        <form id="edit_banned_ip" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
            <textarea id="banned-ips" name="banned-ips" style="width:100%;font-size:0.85em" cols="100" rows="12"><?php echo htmlentities($ips, ENT_QUOTES, 'utf-8')  ?></textarea>
            <div>
                <input name="token" type="hidden"  value="<?php echo SECRET_KEY; ?>" id="token" />
                <input name="rub" type="hidden"  value="<?php echo $rub; ?>" id="rub" />
                <input name="todo"	type="hidden" value="<?php echo $todo; ?>" id="todo" />
                <?php echo cancel_button('?rub=system&amp;todo=list'); ?>
                <input name="save" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="save" />
            </div>
        </form>
    </div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php } ?>