<?php
/**
 * @package linea21\templates\admin
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>
<?php 
if(MOD_DEBUG == 1) $csuffix = '?v='. time(); else $csuffix= '';

if(isset($debugbar)) {
	$debugbar['time']->startMeasure('header', '... loading Header files');
}
?>
<!doctype html>
<html class="no-js" lang="<?php echo U_L; ?>">
<head>
<meta charset="UTF-8">
		<!--[if IE]><meta http-equiv="X-UA-Compatible" content="IE=edge"><![endif]-->
		<title><?php echo _t('header','title');?></title>
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<link rel="shortcut icon" href="<?php echo THEME_ADMIN_PATH; ?>images/favicon.ico" />
		<link rel="stylesheet" href="<?php echo THEME_ADMIN_PATH . 'css/KNACSS/css/knacss.css' .$csuffix; ?>" media="all" />
		<link rel="stylesheet" href="<?php echo THEME_ADMIN_PATH . 'css/admin_common.css' .$csuffix; ?>" media="all" />
		<?php
		// must be included before calling admin_system.css to be able to style .codeMirror
		includeCodeEditor();
		
		if (basename($_SERVER['SCRIPT_NAME']) != 'search.php') {
		  if(file_exists(THEME_ADMIN_PATH. 'css/admin_' . $rub . '.css')) {
		  	echo '<style media="all">';
		    echo '@import url(' .THEME_ADMIN_PATH. 'css/admin_' . $rub . '.css'.$csuffix.');';
		    echo '</style>';
		  }
		} else {
			echo '<style media="all">';
			echo '@import url(' .THEME_ADMIN_PATH. 'css/admin_search.css'.$csuffix.');';
			echo '</style>';
		}
		?>
		<script>
		var SITE_ROOT_URL= "<?php echo SITE_ROOT_URL; ?>";
		var lang = "<?php echo U_L; ?>";
		</script>
		<script src="https://code.jquery.com/jquery-3.6.1.min.js"></script>
		<link rel="stylesheet" href="../lib/js/alertify.js/dist/css/alertify-bootstrap-min.css" />
		<script src="../lib/js/alertify.js/dist/js/alertify.js"></script>
		<link rel="stylesheet" href="../lib/vendor/hint.css-2.7.0/hint.min.css" />
		<link rel="stylesheet" href="<?php echo THEME_ADMIN_PATH; ?>css/layout.css" />
		<?php if(file_exists(THEME_PUBLIC_PATH.'css/admin.css')) { ?>
		<link rel="stylesheet" href="<?php echo PUBLIC_THEME_URL . 'css/admin.css' . $csuffix; ?>" media="all" />
		<?php } ?>
        <?php if(file_exists(THEME_PUBLIC_PATH.'js/admin.js')) { ?>
            <script src="<?php echo PUBLIC_THEME_URL . 'js/admin.js' . $csuffix; ?>"></script>
        <?php } ?>
		<script src="<?php echo THEME_ADMIN_PATH; ?>js/main.js"></script>
		<?php IncludeColorboxJs(array("a[href$='.jpg'],a[href$='.jpeg'],a[href$='.png'],a[href$='.gif'], a[href$='.JPG'],a[href$='.JPEG'],a[href$='.PNG'],a[href$='.GIF']")); ?>
		<?php AddDynamicHeader(); ?>
		<?php if(isset($debugbar)) echo $debugbarRenderer->renderHead(); ?>
		<link rel="stylesheet" href="../lib/vendor/font-awesome/css/font-awesome.min.css">
		<?php if(isset($_REQUEST['light-ui'])) echo '<link rel="stylesheet" href="'. THEME_ADMIN_PATH . 'css/light-ui.css" media="all" />'; ?>
</head>
<body class="<?php echo $rub; ?>-section <?php echo $todo; ?>-action">
<?php
include_once("header.php");
if(isset($debugbar)) {
  $debugbar['time']->stopMeasure('header');
  $debugbar['time']->startMeasure('modules', '... loading modules files');
}
culture::getInstance()->renderSwitcher();

// echo '<div id="wrap">';
include_once(override($dir."/index.php", THEME_ADMIN_PATH));
if(isset($debugbar)) {
  $debugbar['time']->stopMeasure('modules');
  $debugbar['time']->startMeasure('footer', '... loading footer and quickbox files');
}

include_once(override($dir."/help.php", THEME_ADMIN_PATH));
// echo '</div><!-- closing #wrap -->';
include_once(override($dir."/quickbox.php", THEME_ADMIN_PATH));
include_once("footer.php");

if(isset($_SESSION['password-hash-warning'])) {
    unset($_SESSION['password-hash-warning']);
    echo '<script>alertify.error("<div class=\"password-hash-notice\">'.addslashes(sprintf(_t('security', 'password_hash_update'), HrefMaker(array('rub' => $GLOBALS['links'][U_L]['user-prefs']['linkvalue'], '#' => 'signature')))).'</div>", 0);</script>'. PHP_EOL;
}

if(isset($debugbar)) {
  $debugbar['time']->stopMeasure('footer');
}
?>
<script>
	$(document).ready(function(){
		var cboxOptions = { iframe:true, innerWidth: "80%", innerHeight: "80%", maxWidth: "80%", maxHeight: "90%", href: "../library/access.php?langCode=<?php echo U_L; ?>" }
        jQuery("#menu_library").colorbox(cboxOptions);
        jQuery(window).resize(function(){ $.colorbox.resize({ width: window.innerWidth > parseInt(cboxOptions.maxWidth) ? cboxOptions.maxWidth : cboxOptions.width, height: window.innerHeight > parseInt(cboxOptions.maxHeight) ? cboxOptions.maxHeight : cboxOptions.height }); });
	});
</script>
<?php if(isset($debugbar)) echo $debugbarRenderer->render(); ?>
<script src="<?php echo THEME_ADMIN_PATH; ?>js/responsive-menu.js"></script>
</body>
</html>
