<?php
/**
 * User module
 * 
 * Provides basics methods called from public templates
 * These methods can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\core\user
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../user/'.SQL.'.inc.php'));

if(!function_exists('DisplayInfoUser')) {

	function DisplayInfoUser($user_id) {

		$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getAllUserInfo($user_id));

		$content = '';

		if($data == 0) error_redirect();

		if(count($data)!=1) return false;
		else
		{
			// Récupération infos groupes de travail
			include_once('../class/class.user.php');
			$user_object= new user;
			$r=$user_object->GetUserWorkshops($user_id, 'both', $GLOBALS['sql_object']);

			$default_wg= array();
			$wg_rights = array();
			
			if($r !== 0) {
				foreach($r as $value) {
					array_push($default_wg, $value['jwu_workshop_id']);
					$wg_rights[$value['jwu_workshop_id']] = $value['jwu_user_right'];
				}
			}
			$user_workgroups = '';
			if(!empty($default_wg)) {
				$q=SQL_Get_WorkshopsDenomination($default_wg);
				$workgroups=$GLOBALS['sql_object']->DBSelect($q);
				$user_workgroups .= '<ul>';
				foreach($workgroups as $wg) {
					
					if($wg['workshop_statut'] == 'P' || $wg['workshop_statut'] == 'PA') {
						($wg['workshop_statut'] == 'PA') ? $archive = ' ('._t('archives', 'singular').')' : $archive = '';
						$link = array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'], 'id' => $wg['workshop_id'], 'name' => $wg['workshop_denomination']);
						if($wg_rights[$wg['workshop_id']] == 'O') $mask = ' <span class="small">['.formatText(_t('workshop', 'organizer2'), '2HTML').']</span>';
						else  $mask = '';
						$user_workgroups .= '<li><a href="'.HrefMaker($link).'" title="'._t('name','workshop_module').' : '.formatText($wg['workshop_denomination'], '2ATT').'">'.formatText($wg['workshop_denomination'] . $archive, '2HTML').'</a>'.$mask.'</li>'.PHP_EOL;
					}
				}
				$user_workgroups .= '</ul>';
			} else $user_workgroups .= _t('divers', 'none');

			// formattage des données
			$user_login=formatText($data[0]['user_login'], '2HTML');
			$user_public_email=$data[0]['profile_email_display'];
			$user_email_raw=$data[0]['profile_email'];
			$user_email=formatText('<a href="mailto:'.$user_email_raw.'">'.$user_email_raw.'</a>', '2HTML');
			$user_groupe=formatText($data[0]['catus_name'], '2HTML');

			$user_profile_firstname=formatText(empty_nc($data[0]['profile_firstname']), '2HTML');
			$user_profile_lastname=formatText(empty_nc($data[0]['profile_lastname']), '2HTML');
			$user_profile_city=formatText(empty_nc($data[0]['profile_city']), '2HTML');
			$user_profile_birthdate=formatText(empty_nc($data[0]['profile_birthdate']), '2HTML');
			$user_profile_leisures=formatText(empty_nc($data[0]['profile_leisures']), '2HTML');
			$user_profile_job=formatText(empty_nc($data[0]['profile_job']), '2HTML');
			$user_profile_quotation=formatText(empty_nc($data[0]['profile_quotation']), '2HTML');
			$user_profile_signature=formatText(empty_nc($data[0]['profile_signature']), '2HTML');

			if(!empty($data[0]['profile_avatar'])) {
				$complete_uri = SITE_ROOT_URL. $data[0]['profile_avatar'];
				$user_profile_avatar = '<img src="'.$complete_uri.'" alt="'._t('user','avatar').' '.$user_login.'" />';
			} else $user_profile_avatar = _t('divers','none');

			$profile_last_modify_display=$data[0]['profile_last_modify_display'];
			$profile_date_crea_display=$data[0]['profile_date_crea_display'];
			$user_last_con_display=empty_nc($data[0]['user_last_con_display']);

			if ($GLOBALS['l21auth']->isAuthenticated()) $message_link ='<a href="#sendmessage-content" class="button send-message" data-user-login="'.$user_login.'" title="' . formatText(sprintf(_t('contact', 'pm_send_to'), $user_login), '2ATT').'"><i class="fa fa-paper-plane-o" aria-hidden="true"></i> <span>' . sprintf(_t('contact', 'pm_send_to'), $user_login) . '</span></a>';
			else $message_link = '';
			
			
			$content.='<h1>'._t('user','profile').' '.$user_login.'</h1>'.PHP_EOL;
			$content.='<div class="sub-title mbm">';
			$content.=_t('user','h1_public_comment');
			$content.='</div>';
			$content.=GetLinkModifyUserInfo($user_id);
			$content.=$message_link;
			$content.='<div>'.PHP_EOL;
			$content.='<dl>'.PHP_EOL;
			$content.='<dt>'.mb_ucfirst(_t('user','first_name')).' : </dt>'.PHP_EOL;
			$content.='<dd>'. $user_profile_firstname.'</dd>'.PHP_EOL;
			$content.='<dt>'.mb_ucfirst(_t('user','last_name')).' : </dt>'.PHP_EOL;
			$content.='<dd>'. $user_profile_lastname.'</dd>'.PHP_EOL;
			$content.='<dt>'. mb_ucfirst(_t('user','email')). ' : </dt>'.PHP_EOL;
			if($user_public_email=='Y')	$content.='<dd>'.$user_email.'</dd>'.PHP_EOL;
			else $content.='<dd>'._t('statut','draftpdf').'</dd>'.PHP_EOL;
			$content.='<dt>'.mb_ucfirst(_t('user','birthdate')).' : </dt>'.PHP_EOL;
			$content.='<dd>'. $user_profile_birthdate.'</dd>'.PHP_EOL;
			$content.='<dt>'.mb_ucfirst(_t('user','city')).' : </dt>'.PHP_EOL;
			$content.='<dd>'. $user_profile_city.'</dd>'.PHP_EOL;
			$content.='<dt>'.mb_ucfirst(_t('user','leisures')).' : </dt>'.PHP_EOL;
			$content.='<dd>'. $user_profile_leisures.'</dd>'.PHP_EOL;
			$content.='<dt>'.mb_ucfirst(_t('user','job')).' : </dt>'.PHP_EOL;
			$content.='<dd>'. $user_profile_job.'</dd>'.PHP_EOL;
			$content.='<dt>'.mb_ucfirst(_t('user','avatar')).' : </dt>'.PHP_EOL;
			$content.='<dd>'. $user_profile_avatar.'</dd>'.PHP_EOL;
			$content.='<dt>'.mb_ucfirst(_t('user','quotation')).' : </dt>'.PHP_EOL;
			$content.='<dd>'. $user_profile_quotation.'</dd>'.PHP_EOL;
			$content.='<dt>'.mb_ucfirst(_t('user','signature')).' : </dt>'.PHP_EOL;
			$content.='<dd>'. $user_profile_signature.'</dd>'.PHP_EOL;
			$content.='<dt>'.mb_ucfirst(_t('groups','his')).' : </dt>'.PHP_EOL;
			$content.='<dd>'. $user_workgroups.'</dd>'.PHP_EOL;
			$content.='<dt>'.mb_ucfirst(_t('user','type')).' : </dt>'.PHP_EOL;
			$content.='<dd>'.$user_groupe.'</dd>'.PHP_EOL;
			$content.='<dt>'.mb_ucfirst(_t('user','latest_con')).' : </dt>'.PHP_EOL;
			$content.='<dd>'. $user_last_con_display.'</dd>'.PHP_EOL;
			$content.='<dt>'.mb_ucfirst(_t('divers','last_modify')).' : </dt>'.PHP_EOL;
			$content.='<dd>'. $profile_last_modify_display.'</dd>'.PHP_EOL;
			$content.='<dt>'.mb_ucfirst(_t('divers','date_crea')).' : </dt>'.PHP_EOL;
			$content.='<dd>'. $profile_date_crea_display.'</dd>'.PHP_EOL;
			$content.='</dl>'.PHP_EOL;
			$content.='</div>'.PHP_EOL;

		}
		
		echo get_pm_code($user_login);
		
		echo $content;
	}
}

if(!function_exists('DisplayFormProfileUser')) {

	function DisplayFormProfileUser($user_id, $submitted=-1) {

	    include_once('../class/class.user.php');
	    $usero = new user;
	    
		$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getAllUserInfo($user_id));
		$content = '';
		$mask_display_mail_1='';
		$mask_display_mail_2='';

		// Restriction on changing emails and passwords for LDAP users
		if($data[0]['user_password'] == '@ldap_forward') {
			$mask = ' readonly = "readonly"';
		} else {
			$mask = '';
		}

		// ajax code for deleting avatar
		$js = '
		$("a.delete_avatar").click(function() {

		var url = "../user/delavatar.php?mode=ajax";
		$.ajax({
		type: "GET",
		url: url,
		dataType: "json",
		success: function(data) {
		if(data.status==1) {
		$("#avatarcontainer").fadeOut("slow");
	}
	}
	});
	return false;
	});
	';
		
		$pwdsec = [];
		if (defined('PASSWD_STRENGTH')) {
			if (strpos(PASSWD_STRENGTH, 'a') !== false) array_push($pwdsec, _t('user', 'lowercase_char') );
			if (strpos(PASSWD_STRENGTH, 'A') !== false) array_push($pwdsec, _t('user', 'uppercase_char') ) . '<br>';
			if (strpos(PASSWD_STRENGTH, '0') !== false) array_push($pwdsec, _t('user', 'digit_char') ) . '<br>';
			if (strpos(PASSWD_STRENGTH, '/') !== false) array_push($pwdsec, sprintf(_t('user', 'symbol_char'), $usero->SYMBOL_LIST) ) . '<br>';

			$security_msg = '<p class="password-policy pts"><strong>' . _t('user', 'security_policy') . '</strong>'. sprintf(_t('user', 'security_policy_msg'), join(', ', $pwdsec)) .'<p>';
		}

		// en modification simple
		if($submitted==-1) {
			if(!is_array($data)) return false;
			else
			{
				// formattage des données
				$form_login=formatText($data[0]['user_login'], '2FIELD');
				$form_public_email=$data[0]['profile_email_display'];
				$form_email=formatText($data[0]['profile_email'], '2FIELD');
				$current_email=formatText($data[0]['profile_email'], '2FIELD');
				$form_groupe=formatText($data[0]['catus_name'], '2FIELD');
				$current_avatar=$data[0]['profile_avatar'];

				if($form_public_email=='Y') $mask_display_mail_1=' checked="checked"';
				else $mask_display_mail_2=' checked="checked"';
				$form_profile_firstname=formatText($data[0]['profile_firstname'], '2FIELD');
				$form_profile_lastname=formatText($data[0]['profile_lastname'], '2FIELD');
				$form_profile_city=formatText($data[0]['profile_city'], '2FIELD');
				$form_profile_birthdate = isNullDate($data[0]['profile_birthdate']) ? '--' : formatDate($data[0]['profile_birthdate'], true);
				list($form_date_y, $form_date_m, $form_date_d)=explode('-', $form_profile_birthdate);
				$form_profile_leisures=formatText($data[0]['profile_leisures'], '2FIELD');
				$form_profile_job=formatText($data[0]['profile_job'], '2FIELD');
				$form_profile_quotation=formatText($data[0]['profile_quotation'], '2FIELD');
				$form_profile_signature=formatText($data[0]['profile_signature'], '2FIELD');

				if(!empty($data[0]['user_old_logins'])) {
					$old_logins_counter = count(explode(',', $data[0]['user_old_logins'])) - 1;
				} else {
					$old_logins_counter = 0;
				}

				if(!empty($data[0]['profile_avatar'])) {
					$complete_uri ='../'.$data[0]['profile_avatar'];

					$link_delavatar= array('rub'=> $GLOBALS['links'][U_L]['user-prefs']['linkvalue'], 'delavatar' => 1);

					$user_profile_avatar = '<div id="avatarcontainer">';
					$user_profile_avatar.='<img src="'.$complete_uri.'" alt="'._t('user','avatar').' '.$_SESSION['userlogin'].'" />';
					$user_profile_avatar.='<p><a class="delete_avatar" href="'. HrefMaker($link_delavatar).'" title="'._t('user','delete_avatar').'"><span>'._t('user','delete_avatar').'</span></a></p>';
					$user_profile_avatar.='</div>';

					footerAddInlineJS($js);
				} else $user_profile_avatar=_t('divers','none');

				$profile_last_modify_display=$data[0]['profile_last_modify_display'];
				$profile_date_crea_display=$data[0]['profile_date_crea_display'];
			}

			// un submit à déjà été fait, on affiche les infos entrées par l'utilisateur
		} else {
			$form_login=formatText($data[0]['user_login'], '2FIELD');
			$form_email=formatText($_REQUEST['email'], '2FIELD');
			$current_email=formatText($_REQUEST['current_email'], '2FIELD');
			$current_avatar=base64_decode($_REQUEST['current_avatar']);

			if(!empty($data[0]['user_old_logins'])) {
				$old_logins_counter = count(explode(',', $data[0]['user_old_logins'])) - 1;
			} else {
				$old_logins_counter = 0;
			}

			if(!empty($data[0]['profile_avatar'])) {
				$complete_uri='../'.$data[0]['profile_avatar'];

				$link_delavatar= array('rub'=> $GLOBALS['links'][U_L]['user-prefs']['linkvalue'], 'delavatar' => 1);

				$user_profile_avatar = '<div id="avatarcontainer">';
				$user_profile_avatar.='<img src="'.$complete_uri.'" alt="'._t('user','avatar').' '.$_SESSION['userlogin'].'" />';
				$user_profile_avatar.='<p><a class="delete_avatar" href="'. HrefMaker($link_delavatar).'" title="'._t('user','delete_avatar').'"><span>'._t('user','delete_avatar').'</span></a></p>';
				$user_profile_avatar.='</div>';

				footerAddInlineJS($js);

			} else $user_profile_avatar=_t('divers','none');

			if($_REQUEST['email_display']=='Y') $mask_display_mail_1=' checked="checked"';
			else $mask_display_mail_2=' checked="checked"';
			$form_profile_firstname=formatText($_REQUEST['firstname'], '2FIELD');
			$form_profile_lastname=formatText($_REQUEST['lastname'], '2FIELD');
			$form_date_d=formatText($_REQUEST['date_d'], '2FIELD');
			$form_date_m=formatText($_REQUEST['date_m'], '2FIELD');
			$form_date_y=formatText($_REQUEST['date_y'], '2FIELD');
			$form_profile_city=formatText($_REQUEST['city'], '2FIELD');
			$form_profile_leisures=formatText($_REQUEST['leisures'], '2FIELD');
			$form_profile_job=formatText($_REQUEST['job'], '2FIELD');
			$form_profile_quotation=formatText($_REQUEST['quotation'], '2FIELD');
			$form_profile_signature=formatText($_REQUEST['signature'], '2FIELD');
		}

		if(isset($_SESSION['LDAPauthentication'])) $content .= '<div class="info">'._t('security','ldapAuth').'</div>';
		
		$content.='<form action="index.php" method="post" enctype="multipart/form-data">'.PHP_EOL;
		$content.='<div>'.PHP_EOL;
		$content.='<table class="modifyuser">'.PHP_EOL;

		// Do user is authorized to change his login
		if(defined('USER_LOGIN_CHANGE') && USER_LOGIN_CHANGE != 0 && $data[0]['user_password'] != '@ldap_forward') {

			$content.='<tr>'.PHP_EOL;
			$content.='<td>'.PHP_EOL;
			$content.='<span class="labelised labelmargin">'.mb_ucfirst(_t('user','login')).' : </span>'.PHP_EOL;
			$content.='</td>'.PHP_EOL;
			$content.='<td>'.PHP_EOL;
			$content.= $form_login . PHP_EOL;

			if(USER_LOGIN_CHANGE !=  0) {

				// if login has been changed more than USER_LOGIN_CHANGE, we replace the value for displaying
				if($old_logins_counter > USER_LOGIN_CHANGE) $old_logins_counter = USER_LOGIN_CHANGE;
                
				if(empty($_SERVER['QUERY_STRING'])) $link = $_SERVER['SCRIPT_NAME']; else $link = $_SERVER['SCRIPT_NAME'] . '?'. htmlspecialchars($_SERVER['QUERY_STRING'], ENT_QUOTES, CHARSET);
				$content.=' <a href="'.$link.'" style="display:none" id="change-login-link" title="'.sprintf(_t('user', 'change_login_desc'), $old_logins_counter, USER_LOGIN_CHANGE).'">['._t('user', 'change_login').']</a>';
				 
				$content.='<div class="inline-info" id="change-login-form">'.PHP_EOL;

				// if login has been changed more than USER_LOGIN_CHANGE, we replace the value for displaying
				if($old_logins_counter > USER_LOGIN_CHANGE) $old_logins_counter = USER_LOGIN_CHANGE;

				if($old_logins_counter < USER_LOGIN_CHANGE) {
					$content.= sprintf(_t('user', 'change_login_allowed').' - '._t('user', 'change_login_limit_done'), $old_logins_counter, USER_LOGIN_CHANGE).'.<br />'.PHP_EOL;
					$content.= '<input name="newlogin" type="text" class="textfield" id="newlogin" maxlength="150" value="'.$form_login.'" />'.PHP_EOL;

				} else {
					$content.= sprintf(_t('user', 'change_login_limit_reached').' - '._t('user', 'change_login_limit_done'), $old_logins_counter, USER_LOGIN_CHANGE).'.'.PHP_EOL;
				}
				 
				$content.='</div>'.PHP_EOL;

				$js = "$('#change-login-form').css('display', 'none');
				$('#change-login-link').show();
				$('#change-login-link').click(function(e) {
				e.preventDefault();
				$('#change-login-form').slideToggle('slow');
			});";
				 
				footerAddInlineJS($js);

			}
			 
			$content.='</td>'.PHP_EOL;
			$content.='</tr>'.PHP_EOL;
		}

		$content.='<tr>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<label for="email" class="labelised">'.mb_ucfirst(_t('user','email')).' : </label>'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<input name="email" type="text" class="textfield" id="email" maxlength="200"'.$mask.' value="'.$form_email.'" required />'.PHP_EOL;
		$content.='<br />';
// 		$content.='<div class="inline-info">'.PHP_EOL;
// 		$content.=_t('user','info_mail').PHP_EOL;
// 		$content.='</div>'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='</tr>'.PHP_EOL;

		$content.='<tr>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<div class="labelmargin labelised">'.mb_ucfirst(_t('user','email_display')).' : </div>'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<input type="radio" class="radio" id="email_display_Y" class="radio" name="email_display" value="Y"'.$mask_display_mail_1.' required /><label for="email_display_Y" class="autowidth">'._t('divers','yes').'</label>'.PHP_EOL;
		$content.='<input type="radio" class="radio" id="email_display_N" class="radio" name="email_display" value="N"'.$mask_display_mail_2.' /><label for="email_display_N" class="autowidth">'._t('divers','no').'</label>'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='</tr>'.PHP_EOL;
		$content.='<tr>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<label for="firstname" class="labelised">'.mb_ucfirst(_t('user','first_name')).' : </label>'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<input name="firstname" type="text" class="textfield" id="firstname" maxlength="200" value="'.$form_profile_firstname.'" />'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='</tr>'.PHP_EOL;
		$content.='<tr>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<label for="lastname" class="labelised">'.mb_ucfirst(_t('user','last_name')).' : </label>'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<input name="lastname" type="text" class="textfield" id="lastname" maxlength="200" value="'.$form_profile_lastname.'" />'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='</tr>'.PHP_EOL;
		$content.='<tr>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<label for="date_d" class="labelised">'.mb_ucfirst(_t('user','birthdate')).' : </label>'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.= sprintf(input_date($form_date_y, $form_date_m, $form_date_d));
		$content.='</td>'.PHP_EOL;
		$content.='</tr>'.PHP_EOL;
		$content.='<tr>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<label for="city" class="labelised">'.mb_ucfirst(_t('user','city')).' : </label>'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<input name="city" type="text" class="textfield" id="city" maxlength="100" value="'.$form_profile_city.'" />'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='</tr>'.PHP_EOL;
		$content.='<tr>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<label for="leisures" class="labelised">'.mb_ucfirst(_t('user','leisures')).' :</label>'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<input name="leisures" type="text" class="textfield" id="leisures" maxlength="150" value="'.$form_profile_leisures.'" />'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='</tr>'.PHP_EOL;
		$content.='<tr>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<label for="job" class="labelised">'.mb_ucfirst(_t('user','job')).' :</label>'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<input name="job" type="text" class="textfield" id="job" maxlength="150" value="'.$form_profile_job.'" />'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='</tr>'.PHP_EOL;

		$content.='<tr>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<span class="labelmargin labelised">' . mb_ucfirst(_t('user','current_avatar')).' : '.'</span>'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.=$user_profile_avatar.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='</tr>'.PHP_EOL;

		$content.='<tr>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<label for="avatar" class="labelised">'.mb_ucfirst(_t('user','avatar')).' :</label>'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<input name="avatar" type="file" id="avatar" class="textfield" />'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='</tr>'.PHP_EOL;

		$content.='<tr>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<label for="quotation" class="labelised">'.mb_ucfirst(_t('user','quotation')).' :</label>'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<input name="quotation" type="text" class="textfield" id="quotation" maxlength="150" value="'.$form_profile_quotation.'" />'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='</tr>'.PHP_EOL;
		$content.='<tr>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<label for="signature" class="labelised">'.mb_ucfirst(_t('user','signature')).' :</label>'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<input name="signature" type="text" class="textfield" id="signature" maxlength="200" value="'.$form_profile_signature.'" />'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='</tr>'.PHP_EOL;
		$content.='</table>'.PHP_EOL;

		$content.='<hr />'.PHP_EOL;
		$content.='<div class="inline-info">'.PHP_EOL;
		$content.=_t('user','info_password').PHP_EOL;
		$content.='</div>'.PHP_EOL;
		$content.='<table class="modifyuser">'.PHP_EOL;
		$content.='<tr>'.PHP_EOL;
		$content.='<td style="vertical-align:top">'.PHP_EOL;
		$content.='<label for="password" class="labelised">'.mb_ucfirst(_t('user','p_new_password')).' : <br /><span class="italic">(' . sprintf(_t('password', 'minimum'), PASSWD_MINLENGTH) . ')</span></label>'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<input name="password" type="password" class="textfield" id="password"'.$mask.' maxlength="100" value="" />'.PHP_EOL;
		$content.='<div id="pwd-complexity" class="default"></div>'.PHP_EOL;
		if(isset($security_msg)) $content .=  $security_msg;
		$content.='</td>'.PHP_EOL;
		$content.='</tr>'.PHP_EOL;
		$content.='<tr>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<label for="password2" class="labelised">'.mb_ucfirst(_t('user','p_new_password_confirm')).' : </label>'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='<td>'.PHP_EOL;
		$content.='<input name="password2" type="password" class="textfield" id="password2"'.$mask.' maxlength="100" value="" />'.PHP_EOL;
		$content.='</td>'.PHP_EOL;
		$content.='</tr>'.PHP_EOL;
		$content.='</table>'.PHP_EOL;

		$content.='</div>'.PHP_EOL;
		$content.='<input name="current_email" type="hidden" value="'.$current_email.'" id="current_email" />'.PHP_EOL;
		$content.='<input name="current_avatar" type="hidden" value="'.base64_encode($current_avatar).'" id="current_avatar" />'.PHP_EOL;
		$content.='<input name="id" type="hidden" value="'.$user_id.'" id="id" />'.PHP_EOL;
		$content.='<input name="rub" type="hidden" id="rub" value="'.$GLOBALS['links'][U_L]['user-prefs']['linkvalue'].'" />'.PHP_EOL;
		$content.='<div class="submit-container"><input type="submit" class="submitbut" value="'._t('btn','valid').'" title="'._t('btn','valid').'" name="modprofile" id="modprofile" /></div>'.PHP_EOL;
		$content.='</form>'.PHP_EOL;

		$js_password_inputs = 'var minPasswordLength = '.PASSWD_MINLENGTH.';
		var msg_novalue = "'._t('password_strength', 'novalue').'";
		var msg_short = "'.sprintf(_t('password_strength', 'too_short'), PASSWD_MINLENGTH).'";
		var msg_weak = "'._t('password_strength', 'weak').'";
		var msg_average = "'._t('password_strength', 'average').'";
		var msg_strong = "'._t('password_strength', 'strong').'";
		var msg_secure = "'._t('password_strength', 'secure').'";
		';

		echo '<script>'.$js_password_inputs.'</script>';
		footerAddJS('../lib/js/mocha.js');

		echo $content;
	}
}

if(!function_exists('ModifyProfile')) {

	function ModifyProfile() {

		/** include envoi de mail */
		include(override('../mail/mail_actions.php'));
		include(override('../mail/send.php'));
		$a = array();
		
		$link_home= array('rub'=> $GLOBALS['links'][U_L]['home']['linkvalue']);

		$id=base64_decode($_SESSION['userid']);
		$integrity=1;
		
		$table_user = array();

		if(isset($_REQUEST['newlogin']) && $_REQUEST['newlogin'] != $GLOBALS['l21auth']->GetSessionElement('login')) {
			$table_user[0] = $_REQUEST['newlogin'];
			$_SESSION['userfirstname'] = $_REQUEST['firstname'];
			$logincheck = true;
		} else {
			$table_user[0] = $GLOBALS['l21auth']->GetSessionElement('login');
			$logincheck = false;
		}

		$new_login = $table_user[0];
		$current_login = $GLOBALS['l21auth']->GetSessionElement('login');


		$table_user[1] =$_REQUEST['email'];
		$table_profile[0] = $_REQUEST['email'];
		$table_profile[1] = $_REQUEST['email_display'];
		$table_profile[2] = $_REQUEST['city'];
		$form_date_d = trim($_REQUEST['date_d']);
		$form_date_m = trim($_REQUEST['date_m']);
		$form_date_y = trim($_REQUEST['date_y']);
		$form_date=$form_date_d . '-' . $form_date_m . '-' . $form_date_y;

		if(!empty($form_date_d) || !empty($form_date_m) || !empty($form_date_y)) {
			$date_integrity=checkdate_validity($form_date);
		} else {
			$date_integrity=true;
		}
		if(is_string($date_integrity)) $integrity = $date_integrity;
		else {
			$table_profile[3]= $form_date;
		}

		$table_profile[4] = $_REQUEST['leisures'];
		$table_profile[5] = $_REQUEST['job'];
		$table_profile[6] = $_REQUEST['quotation'];
		$table_profile[7] = $_REQUEST['signature'];
		$table_profile[8] = $_REQUEST['firstname'];
		$table_profile[9] = $_REQUEST['lastname'];
		$table_profile[10] = base64_decode($_REQUEST['current_avatar']);

        // we check if user as changed email or not 
		if($_REQUEST['email'] != $_REQUEST['current_email']) $uniqueMailBypass = false;
		else $uniqueMailBypass = true;
		include_once('../class/class.user.php');
		$user_object= new user;
		$data_user_integrity=$user_object->CheckDataIntegrity($table_user, $GLOBALS['sql_object'], $logincheck, $uniqueMailBypass);
		if(is_string($data_user_integrity)) $integrity=$data_user_integrity;

		if(!empty($_REQUEST['password']) && !is_string($integrity)) {
			$integrity=$user_object->checkPasswordValidity($_REQUEST['password'], $_REQUEST['password2']);
		}
		if(!is_string($integrity)) {
			if(isset($_FILES['avatar']) && $_FILES['avatar']['name']!='') {
				include_once('../class/system/class.upload.php');
				$upload_object= new upload;
				$upload=$_FILES['avatar'];
				$size_integrity=$upload_object->CheckMaxFile($upload['size'], $user_object->UPLOAD_MAX_MO);
				if(is_string($size_integrity)) $integrity=$size_integrity;
				$format_integrity=$upload_object->CheckExtImage($upload['name']);
				if(is_string($format_integrity)) $integrity=$format_integrity;
				if(!is_string($integrity)) {
					$final_name=$id.".".$upload_object->GetExtension($upload ['name']);
					$table_profile[10]=$user_object->URI_INPUT.$final_name;

					$destination="../".$user_object->URI_INPUT;

					$result_upload=$upload_object->UploadFile($upload, $final_name, $destination);

					// we remove all images with same name except the image just uploaded
					$upload_object->deleteImages($destination.$final_name, true);
				}
			}
		}

		if(!is_string($integrity)) {
			$result=$user_object->ModifyProfile($id, $table_profile, $GLOBALS['sql_object']);
			if($result == true) {
				$string =_t('user','p_confirm_mod').'.';
				$string.=' <a href="'.HrefMaker($link_home).'" title="'._t('user','p_confirm_back').'" >'._t('user','p_confirm_back').'</a>';
				$integrity = array('code'=> 'confirmed', 'string' => $string);
			}

			// Change login if needed
			if($new_login != $current_login) {

				$r = $user_object->changeLogin($id, $new_login, $current_login, $GLOBALS['sql_object']);

				if($r == true) {
					$_SESSION['userlogin']= $new_login;
				}

				$user_email = $_REQUEST['email'];

				/** include envoi de mail */
				$a['login'] = $new_login;
			  $a['action'] ='change_login';
			  $a['recipient'] = $user_email;
			  
			  $emailContainer = prepare_email($a);
			  $r = send_email($emailContainer);
			}

			// Changing password
			if(!empty($_REQUEST['password'])) {
			    // $a['password'] = $_REQUEST['password'];
			    $a['password'] = _t('user', 'secret_password');
			    $a['action'] = 'change_pass';	 // choix template pour mail
			    $a['recipient'] = $_REQUEST['email']; // renseignement email
			    $a['login'] = $_SESSION['userlogin']; // retrieve login
			    
			    $r = $user_object->UpdateUserPassword($id, $_REQUEST['password'], $GLOBALS['sql_object']);
			    
			    /** include envoi de mail */
			    $emailContainer = prepare_email($a);
			    $r = send_email($emailContainer);
			}
			
			// Changing email
            if($_REQUEST['email'] != $_REQUEST['current_email']) {
			    $a['action'] = 'change_mail';	 // choix template pour mail
				$a['recipient'] = $_REQUEST['email']; 	// renseignement nouvel email
				$a['login'] = $_SESSION['userlogin']; // retrieve login
				
				/** include envoi de mail */
				$emailContainer = prepare_email($a);
				$r = send_email($emailContainer);
			}


		} else {
			$integrity = array('code'=> 'error', 'string' => $integrity);
		}

		$return_result ='<div class="'.$integrity['code'].'">'.PHP_EOL;
		$return_result.=$integrity['string'].PHP_EOL;
		$return_result.='</div>'.PHP_EOL;

		return $return_result;
	}
}

if(!function_exists('deleteUserAvatar')) {

	function deleteUserAvatar() {

		include_once('../user/delavatar.php');
			
		$str ='<div class="confirmed">'.PHP_EOL;
		$str.=_t('user','confirm_delavatar').PHP_EOL;
		$str.='</div>'.PHP_EOL;
		echo $str;
	}
}

if(!function_exists('ChangeNotifySettings')) {

	function ChangeNotifySettings($user_id) {

		include_once('../class/class.user.php');
		$user_object= new user;

		$allgroups = array();
		$checked = array();
		$disabled = array();

		// get workgroups
		$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getUserWorkgroups($user_id));
		if($data == 0) return false;

		foreach($data as $el) {
			array_push($allgroups, 'topic-'.$el['id']);
			array_push($allgroups, 'post-'.$el['id']);
			array_push($allgroups, 'file-'.$el['id']);
		}

		if(isset($_POST['topic'])) {
			foreach($_POST['topic'] as $el) {
				array_push($checked, 'topic-'.$el);
			}
		}
		if(isset($_POST['post'])) {
			foreach($_POST['post'] as $el) {
				array_push($checked, 'post-'.$el);
			}
		}
		if(isset($_POST['file'])) {
			foreach($_POST['file'] as $el) {
				array_push($checked, 'file-'.$el);
			}
		}
		if(isset($_POST['disabledfields'])) {
			$disabled = unserialize(rawurldecode($_POST['disabledfields']));
		}

		$checked = array_merge($disabled, $checked);

		// diff between all groups and checked boxes
		$exceptions = array_diff($allgroups, $checked);
		$r = $user_object->changeWorkshopsNotification($user_id, $exceptions, $GLOBALS['sql_object']);

		$str ='<div class="confirmed">'.PHP_EOL;
		$str.=_t('user','notify_changes_success').PHP_EOL;
		$str.='</div>'.PHP_EOL;
		echo $str;
	}
}

if(!function_exists('GetLinkSeeUserInfo')) {

    function GetLinkSeeUserInfo($user_id)
    {
        $content = '';

        $link_myprofile = array('rub' => $GLOBALS['links'][U_L]['user-profile']['linkvalue'], 'id' => $user_id);

        $content .= '<div id="see-profile">' . PHP_EOL;
        $content .= '<a class="button buttonmargin" href="' . HrefMaker($link_myprofile) . '" title="' . _t('user', 'see-your-profile') . '">' . _t('user', 'see-your-profile') . '</a>';
        $content .= '</div>' . PHP_EOL;

        return $content;
    }
}

if(!function_exists('GetLinkModifyUserInfo')) {

	function GetLinkModifyUserInfo($user_id) {

		$content ='';
		if(isset($_SESSION['authenticated']) && $user_id==base64_decode($_SESSION['userid'])) {
			$link_edit= array('rub'=> $GLOBALS['links'][U_L]['user-prefs']['linkvalue']);

			$content.='<div id="edit-profile">'.PHP_EOL;
			$content.='<a class="button buttonmargin" href="'.HrefMaker($link_edit).'" title="'._t('user','p_mod').'">'._t('user','p_mod').'</a>';
			$content.='</div>'.PHP_EOL;
		}
		return $content;
	}
}

if(!function_exists('DisplayAuthTextInfo')) {

	function DisplayAuthTextInfo() {
		
		if(defined('FREE_REGISTRATION') && FREE_REGISTRATION == 0)  return '';
		$link_account= array('rub'=> $GLOBALS['links'][U_L]['user-registration']['linkvalue']);
		$content ='<div class="info">'.PHP_EOL;
		$content.=_t('user','info_inscription').PHP_EOL;
		$content.='<a href="'.HrefMaker($link_account).'">'._t('user','info_inscription2').' </a>'.PHP_EOL;
		$content.='.<br />'._t('user','info_inscription3').''.PHP_EOL;
		$content.='</div>'.PHP_EOL;
		echo $content;
	}
}

if(!function_exists('DisplayMyContribs')) {
    
    function DisplayMyContribs($user_id) {
        $content ='<h2 id="my-contribs">'._t('contribs','mine').'</h2>'.PHP_EOL;
        $content.='<div>'.PHP_EOL;
        $content.= getUserComment(array('module'=> 'contribute', 'module_id'=> '1', 'user_id'=> $user_id, 'order_by' => 'ASC'), false, true);
        $content.='</div>';
        
        echo $content;
    }
}


if(!function_exists('DisplayWorkgroupsSettings')) {

	function DisplayWorkgroupsSettings($user_id) {
		$content ='<h2>'._t('user','my_workgroups').'</h2>'.PHP_EOL;
		$content.='<div class="personnalsettings">'.PHP_EOL;
		$content.='<p>'._t('user','workgroups_notification').'</p>'.PHP_EOL;
		$content.=getWorkgroupsNotificationTable($user_id);
		$content.='</div>';

		echo $content;
	}
}

if(!function_exists('getWorkgroupsNotificationTable')) {

	function getWorkgroupsNotificationTable($user_id) {

		$exceptions = array();
		$disabled_fields = array();

		// get workgroups
		$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getUserWorkgroups($user_id));

		// get notification exceptions
		$exc=$GLOBALS['sql_object'] -> DBSelect(SQL_getUserNotifyExceptionsSettings($user_id));


		if($exc!=0) {
			foreach($exc as $el) {
				array_push($exceptions, $el['exception']);
			}
		}
		// default mask
		$dmask='checked="checked"';

		if($data==0) return false;

		// general config
		if(ALERT_NEWTOPIC==2) {
			$is_topicDisabled='';
		} else {
			$is_topicDisabled=' disabled="disabled"';
		}
		if(ALERT_NEWPOST==2) {
			$is_postDisabled='';
		} else {
			$is_postDisabled=' disabled="disabled"';
		}
		if(ALERT_NEWFILE==2) {
			$is_fileDisabled='';
		} else {
			$is_fileDisabled=' disabled="disabled"';
		}


		$content  ='<form action="index.php" method="post">'.PHP_EOL;
		$content .= "<table>";
		$content .= "<thead>";
		$content .= "<tr>";
		$content .= "<td>"._t('user','workgroups_label')."</td>";
		$content .= "<td class=\"txtcenter\">".str_replace(' - ', '<br />', _t('user','notify_topic'))."</td>";
		$content .= "<td class=\"txtcenter\">".str_replace(' - ', '<br />',_t('user','notify_post'))."</td>";
		$content .= "<td class=\"txtcenter\">".str_replace(' - ', '<br />',_t('user','notify_file'))."</td>";
		$content .= "</tr>";
		$content  .= "</thead>";
		$content  .= "<tbody>";
		foreach($data as $el) {

			if(in_array('topic-'.$el['id'], $exceptions)) {
				$topic_mask = '';
				$topic_on_class='';
				$topic_off_class=' selected';
			} else {
				$topic_mask = $dmask;
				$topic_on_class=' selected';
				$topic_off_class='';
				// we handle disabled fields because they are not sent to server !!!
				if(ALERT_NEWTOPIC!=2) array_push($disabled_fields, 'topic-'.$el['id']);
			}
			if(in_array('post-'.$el['id'], $exceptions)) {
				$post_mask = '';
				$post_on_class='';
				$post_off_class=' selected';
			} else {
				$post_mask = $dmask;
				$post_on_class=' selected';
				$post_off_class='';
				// we handle disabled fields because they are not sent to server !!!
				if(ALERT_NEWPOST!=2) array_push($disabled_fields, 'post-'.$el['id']);
			}
			if(in_array('file-'.$el['id'], $exceptions) ) {
				$file_mask = '';
				$file_on_class='';
				$file_off_class=' selected';
			} else {
				$file_mask = $dmask;
				$file_on_class=' selected';
				$file_off_class='';
				// we handle disabled fields because they are not sent to server !!!
				if(ALERT_NEWFILE!=2) array_push($disabled_fields, 'file-'.$el['id']);
			}

// 			$content .= "<tr>";
// 			$content .= "<td>".$el['name']."</td>";
// 			$content .= "<td class=\"center\"><p class=\"switch\"><label class=\"cb-enable".$topic_on_class."\"><span>"._t('divers', 'yes')."</span></label><label class=\"cb-disable".$topic_off_class."\"><span>"._t('divers', 'no')."</span></label><input".$is_topicDisabled." type=\"checkbox\" ".$topic_mask." value=\"".$el['id']."\" id=\"topic-".$el['id']."\" name=\"topic[]\" /></p></td>";
// 			$content .= "<td class=\"center\"><p class=\"switch\"><label class=\"cb-enable".$post_on_class."\"><span>"._t('divers', 'yes')."</span></label><label class=\"cb-disable".$post_off_class."\"><span>"._t('divers', 'no')."</span></label><input".$is_postDisabled." type=\"checkbox\" ".$post_mask." value=\"".$el['id']."\" id=\"post-".$el['id']."\" name=\"post[]\" /></p></td>";
// 			$content .= "<td class=\"center\"><p class=\"switch\"><label class=\"cb-enable".$file_on_class."\"><span>"._t('divers', 'yes')."</span></label><label class=\"cb-disable".$file_off_class."\"><span>"._t('divers', 'no')."</span></label><input".$is_fileDisabled." type=\"checkbox\" ".$file_mask." value=\"".$el['id']."\" id=\"file-".$el['id']."\" name=\"file[]\" /></p></td>";
// 			$content .= "</tr>";
			$content .= "<tr>";
			$content .= "<td>".$el['name']."</td>";
			$content .= "<td class=\"txtcenter\"><p><input".$is_topicDisabled." type=\"checkbox\" ".$topic_mask." value=\"".$el['id']."\" id=\"topic-".$el['id']."\" name=\"topic[]\" class=\"switch\" /></p></td>";
			$content .= "<td class=\"txtcenter\"><p><input".$is_postDisabled." type=\"checkbox\" ".$post_mask." value=\"".$el['id']."\" id=\"post-".$el['id']."\" name=\"post[]\" class=\"switch\" /></p></td>";
			$content .= "<td class=\"txtcenter\"><p><input".$is_fileDisabled." type=\"checkbox\" ".$file_mask." value=\"".$el['id']."\" id=\"file-".$el['id']."\" name=\"file[]\" class=\"switch\" /></p></td>";
			$content .= "</tr>";
		}
		$content .= "</tbody>";
		$content .= "</table>";
		$content .='<input type="hidden" name="disabledfields" id="disabledfields" value="'.rawurlencode(serialize($disabled_fields)).'" />'.PHP_EOL;
		$content .='<input type="hidden" name="rub" id="rub2" value="'.$GLOBALS['links'][U_L]['user-prefs']['linkvalue'].'" />'.PHP_EOL;
		$content .='<div class="submit-container"><input type="submit" class="submitbut" value="'._t('btn','valid').'" title="'._t('btn','valid').'" name="notifyUpdate" id="notifyUpdate" /></div>'.PHP_EOL;
		$content .= "</form>";


		return $content;
	}
}
?>
