<?php
/**
 * Workshop module - getting and displaying workgroup files
 * 
 * Display files list of a given workshop. Called when a new file is added from front-office  
 *  
 * @package linea21\modules\workshop
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

$noplugin = true; // flag for ../config/define.php file
include_once('../config/define.php');

securityCheck();

$id=$_GET['id'];
$url=strip_tags($_GET['rooturl']);
$folder=strip_tags($_GET['folder']);



// is it shared file(s) or not ?
if(strpos($folder, 'shared') === false) {
	$is_shared = false;
} else {
	$is_shared = true;
}

if(isset($_GET['upfiles'])) {
	$files = trim($_GET['upfiles'], '|');
  $a=explode('|', $files);
  $files = array();
  foreach($a as $file) {
    $filename_parts = pathinfo($file);
    $filename = Stringy\Stringy::create($filename_parts['filename'], CHARSET)->slugify().'.'.$filename_parts['extension'];
    
    array_push($files, $filename);
  }
}

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isWorkgroupUser($id, $sql_object)) ReloadIndex('public');
////////////


include_once('../languages/' . U_L . '/lang_workshop.' . CHARSET . '.php');
include_once('../languages/' . U_L . '/lang_common.' . CHARSET . '.php');

 // necessary includes for ajax calls
  if(MOD_COMMENT == 1) {
  include_once('../languages/' . U_L . '/lang_comment.' . CHARSET . '.php');
  include_once(override('../comment/'.SQL.'.inc.php'));
}
include_once(override('../workshop/display.php'));

DisplayFiles($id, $url);

// notify users by mail
notifyUsersMsg(array('action' => 'file_alert','user' => $_SESSION['userlogin'] ,'owner' => $_SESSION['userlogin'], 'files' => $files, 'id' => $id, 'is_shared'=> $is_shared));
?>