<?php
/**
 * Workshop report module
 * 
 * Add a report to a workgroup page
 * 
 * @package linea21\modules\workshoprep
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Workshoprep' (as Workshop Report) module is used by 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////


if(isset($_GET['work_id'])) $work_id=$_GET['work_id'];
if(isset($_POST['work_id'])) $work_id=$_POST['work_id'];
$cancel_action_link="?rub=workshop&amp;todo=det&amp;id=".$work_id;


$requete=SQL_getWorkshopDenomination($work_id);
$result=$sql_object->DBSelect($requete);
if(count($result)>1) exit();
$workrep_workshop_name=$result[0]['workshop_denomination'];

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('workshop')) ReloadIndex('admin');
if(!$l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $work_id) && !$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////
$rub_link="index.php?rub=workshop";
?>

<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','workshop'); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('workshoprep','add'). " (" .$workrep_workshop_name.")"); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
$form_title='';
$form_resume='';
$form_comment='';
$mask_statut_P='';
$mask_statut_D="checked=\"checked\"";
$mask_visible_Y="checked=\"checked\"";
$mask_visible_N='';


$workshop_report_object= new workshop_report;

if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
  $result=$workshop_report_object->AddWorkshopReport($data_table, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$result;
  if(is_numeric($result)) {
      header("Location: ".safe_redirect($link_confirm));
      exit;
  }
  else  system_error();
}

if(isset($_POST['valider'])) {
    
  $table = array();
  
  $table[0]=$_POST['workrep_title'];
  $table[1]=$_POST['workrep_resume'];
  $table[2]=$_POST['workrep_comment'];
  $table[3]=$_POST['workrep_statut'];
  $table[4]=$_POST['work_id'];
  $table['visible']=$_POST['workrep_visible'];

  $integrity=$workshop_report_object->CheckDataIntegrity($table, $sql_object);

  if(is_string($integrity)) {
    $text_format='2FIELD';
  } else {
    $text_format='2HTML';
  }
  $form_title=formatText($_POST['workrep_title'], $text_format);
  $form_resume=formatText($_POST['workrep_resume'], $text_format);

  $form_comment=formatText($_POST['workrep_comment'], $text_format);
  
  if($_POST['workrep_visible'] == 1) {
      $display_form_visible = _t('divers', 'yes');
  } else {
      $display_form_visible = _t('divers', 'no');
  }

  if($_POST['workrep_statut']=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($_POST['workrep_statut']=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
  if($_POST['workrep_visible']==0) $mask_visible_N="checked=\"checked\""; else $mask_visible_N='';
  if($_POST['workrep_visible']==1) $mask_visible_Y="checked=\"checked\""; else $mask_visible_Y='';
  
  $table=urlencode(serialize($table));
}

?>

<?php
if(!isset($integrity) || is_string($integrity)) {
?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2(_t('workshoprep','add_title'). " (" .$workrep_workshop_name.")"); ?></h2>
<form id="addworkrep" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<p>
	<label for="workrep_title"><?php echo mb_ucfirst(_t('workshoprep','title')); ?>&nbsp;:&nbsp;*</label>
	<input name="workrep_title" type="text" class="textfield" id="workrep_title" maxlength="200" value="<?php echo $form_title; ?>" required />
</p>
<p>
	<label for="workrep_resume"><?php echo mb_ucfirst(_t('workshoprep','resume')); ?>&nbsp;:&nbsp;*</label>
	<textarea id="workrep_resume" name="workrep_resume" class="largetextfield" <?php echo AREA_SETTINGS; ?> required><?php echo $form_resume; ?></textarea>
</p>
<div class="label"><?php echo mb_ucfirst(_t('workshoprep','visible')); ?> : </div>
<div class="rightpanel">
    	<input name="workrep_visible" type="radio" class="radio" id="visible_N" value="0" <?php echo $mask_visible_N; ?> required />
    	<label for="visible_N"><?php echo mb_ucfirst(_t('divers','no')); ?></label>
    	<input name="workrep_visible" type="radio" class="radio" id="visible_Y" value="1" <?php echo $mask_visible_Y; ?> />
    	<label for="visible_Y"><?php echo mb_ucfirst(_t('divers','yes')); ?></label>
</div><br />
<div class="label"><?php echo mb_ucfirst(_t('workshoprep','statut')); ?> : </div>
<div class="rightpanel">
  <input name="workrep_statut" type="radio" class="radio" id="statut_P" value="P" <?php echo $mask_statut_P; ?> required />
  <label for="statut_P"><?php echo mb_ucfirst(_t('statut','public')); ?></label>
  <input name="workrep_statut" type="radio" class="radio" id="statut_D" value="D" <?php echo $mask_statut_D; ?> />
  <label for="statut_D"><?php echo mb_ucfirst(_t('statut','draft')); ?></label>
</div>
<p>
	<label for="workrep_comment"><?php echo mb_ucfirst(_t('workshoprep','comment')); ?> : </label>
	<textarea id="workrep_comment" name="workrep_comment" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_comment; ?></textarea>
</p>
  <div>
  	<input name="work_id" type="hidden" value="<?php echo $work_id; ?>" id="work_id" />
  	<input name="rub" type="hidden"	value="<?php echo $rub; ?>" id="rub" />
  	<input name="todo"	type="hidden" value="<?php echo $todo; ?>" id="todo" />
  	<?php echo cancel_button($cancel_action_link); ?>
  	<input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
// Récapitulatif
} else	{

  if(empty($form_comment)) $display_form_comment=_t('divers','none');
  else $display_form_comment=$form_comment;

  ?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo _t('recap','title') ?></h2>
<?php
echo "<dl class=\"summary\">\n";
echo "<dt>".mb_ucfirst(_t('workshoprep','title'))." :</dt>\n";
echo "<dd>". $form_title."</dd>\n";
echo "<dt>". mb_ucfirst(_t('workshoprep','resume')). " :</dt>\n";
echo "<dd>". $form_resume."</dd>\n";
echo "<dt>". mb_ucfirst(_t('workshoprep','visible')) ." :</dt>\n";
echo "<dd>". $display_form_visible. "</dd>\n";
echo "<dt>". mb_ucfirst(_t('divers','statut')) ." :</dt>\n";
echo "<dd>". display_statut($_POST['workrep_statut']). "</dd>\n";
echo "<dt>".mb_ucfirst(_t('workshoprep','comment')) ." :</dt>\n";
echo "<dd>". $display_form_comment. "</dd>\n";
echo "</dl>\n";
?>
<form id="addworkrep" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
  <div>
    <input name="work_id" type="hidden" value="<?php echo $work_id; ?>" id="work_id" />
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
    <input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
    <input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php } ?>